/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.text.NumberFormat;
import java.util.ArrayList;
import jhi.flapjack.data.XMLRoot;
import scri.commons.gui.RB;

public class BinnedData
extends XMLRoot {
    private ArrayList<BinData> bins = new ArrayList();

    public ArrayList<BinData> getBins() {
        return this.bins;
    }

    public void setBinData(ArrayList<BinData> bins) {
        this.bins = bins;
    }

    public void addBin(int index, float min, float max) {
        this.bins.add(new BinData(index, min, max));
    }

    public BinData getBin(int index) {
        return this.bins.get(index);
    }

    public String getBinForState(String alleleState) {
        if (!this.bins.isEmpty()) {
            try {
                int bin = Integer.parseInt(alleleState);
                return this.getBin(bin).range();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return "";
    }

    public boolean containsBins() {
        return !this.bins.isEmpty();
    }

    public static class BinData
    extends XMLRoot {
        public int index;
        public float min;
        public float max;
        private static final NumberFormat nf = NumberFormat.getInstance();

        public BinData() {
        }

        BinData(int index, float min, float max) {
            this.index = index;
            this.min = min;
            this.max = max;
            nf.setMaximumFractionDigits(3);
        }

        public String range() {
            return RB.format((String)"data.BinnedData.BinData.range", (Object[])new Object[]{nf.format(this.min), nf.format(this.max)});
        }

        public String toString() {
            return this.index + " " + this.range();
        }
    }
}

