/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.handlers;

import java.lang.reflect.Array;
import java.util.StringTokenizer;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.ValidityException;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLFieldHandler;

public class CollectionFieldHandler
extends XMLFieldHandler {
    private final FieldHandler _handler;
    private final TypeValidator _validator;

    public CollectionFieldHandler(FieldHandler fieldHandler) {
        this(fieldHandler, null);
    }

    public CollectionFieldHandler(FieldHandler fieldHandler, TypeValidator validator) {
        if (fieldHandler == null) {
            String err = "The FieldHandler argument passed to the constructor of CollectionFieldHandler must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._handler = fieldHandler;
        this._validator = validator;
    }

    @Override
    public void setValue(Object target, Object value) throws IllegalStateException {
        if (value == null) {
            return;
        }
        if (!(value instanceof String)) {
            this._handler.setValue(target, value);
            return;
        }
        StringTokenizer temp = new StringTokenizer((String)value, " ");
        int size = temp.countTokens();
        for (int i = 0; i < size; ++i) {
            String tempValue = temp.nextToken();
            try {
                if (this._validator != null) {
                    this._validator.validate(tempValue, null);
                }
            }
            catch (ValidationException e) {
                throw new IllegalStateException(e.getMessage());
            }
            this._handler.setValue(target, tempValue);
        }
    }

    @Override
    public Object getValue(Object target) throws IllegalStateException {
        Object temp = this._handler.getValue(target);
        if (temp == null) {
            return temp;
        }
        if (!temp.getClass().isArray()) {
            return temp.toString();
        }
        int size = Array.getLength(temp);
        if (size == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                result.append(' ');
            }
            Object obj = Array.get(temp, i);
            result.append(obj);
        }
        return result.toString();
    }

    @Override
    public void resetValue(Object target) throws IllegalStateException {
        this._handler.resetValue(target);
    }

    @Override
    public void checkValidity(Object object) throws ValidityException, IllegalStateException {
    }

    @Override
    public Object newInstance(Object parent) throws IllegalStateException {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XMLFieldHandler)) {
            return false;
        }
        return this._handler.getClass().isInstance(obj);
    }
}

