/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm.util;

public class InodeCache {
    private static final Object PLACEHOLDER = new Object();
    private static final short SHORT_PLACEHOLDER = -2;
    private static final short SHORT_NULL = -1;
    private static final int LOAD_FACTOR = 2;
    private final int maxSize;
    private final int totalSlots;
    private final int maxUsedSlots;
    private final Object[] keys;
    private final short[] next;
    private final short[] prev;
    private final short[] inodes;
    private final short[] reverse;
    private int size;
    private int usedSlots;
    private short mru;
    private short lru;

    public InodeCache() {
        this(1024);
    }

    public InodeCache(int n) {
        this.maxSize = n;
        this.totalSlots = n * 2 * 2 + 3;
        this.maxUsedSlots = this.totalSlots / 2;
        if (this.totalSlots > Short.MAX_VALUE) {
            throw new IllegalArgumentException("cache size too large");
        }
        this.keys = new Object[this.totalSlots];
        this.next = new short[this.totalSlots];
        this.prev = new short[this.totalSlots];
        this.inodes = new short[this.totalSlots];
        this.reverse = new short[this.totalSlots];
        this.clear();
    }

    private static void fill(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = object;
        }
    }

    private static void fill(short[] sArray, short s) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = s;
        }
    }

    public final void clear() {
        this.usedSlots = 0;
        this.size = 0;
        this.lru = (short)-1;
        this.mru = (short)-1;
        InodeCache.fill(this.keys, null);
        InodeCache.fill(this.inodes, (short)-1);
        InodeCache.fill(this.reverse, (short)-1);
    }

    public final short get(Object object) {
        int n;
        Object object2;
        int n2;
        int n3 = object.hashCode() & Integer.MAX_VALUE;
        int n4 = n2 = n3 % this.totalSlots;
        int n5 = 1;
        boolean bl = true;
        int n6 = -1;
        while ((object2 = this.keys[n2]) != null) {
            if (object2 == PLACEHOLDER) {
                if (n6 == -1) {
                    n6 = n2;
                }
            } else if (object2.equals(object)) {
                short s = this.inodes[n2];
                if (n2 == this.mru) {
                    return s;
                }
                if (this.lru == n2) {
                    this.lru = this.next[this.lru];
                } else {
                    short s2;
                    short s3 = this.prev[n2];
                    this.next[s3] = s2 = this.next[n2];
                    this.prev[s2] = s3;
                }
                this.prev[n2] = this.mru;
                this.next[this.mru] = (short)n2;
                this.mru = (short)n2;
                return s;
            }
            n2 = Math.abs((n4 + (bl ? 1 : -1) * n5 * n5) % this.totalSlots);
            if (!bl) {
                ++n5;
            }
            bl = !bl;
        }
        if (n6 == -1) {
            n = n2;
            if (this.usedSlots == this.maxUsedSlots) {
                this.clear();
                return this.get(object);
            }
            ++this.usedSlots;
        } else {
            n = n6;
        }
        if (this.size == this.maxSize) {
            this.keys[this.lru] = PLACEHOLDER;
            this.inodes[this.lru] = -2;
            this.lru = this.next[this.lru];
        } else {
            if (this.size == 0) {
                this.lru = (short)n;
            }
            ++this.size;
        }
        int n7 = n3 & Short.MAX_VALUE;
        while (true) {
            block24: {
                short s;
                n4 = n2 = n7 % this.totalSlots;
                n5 = 1;
                bl = true;
                n6 = -1;
                while ((s = this.reverse[n2]) != -1) {
                    short s4 = this.inodes[s];
                    if (s4 == -2) {
                        if (n6 == -1) {
                            n6 = n2;
                        }
                    } else if (s4 == n7) break block24;
                    n2 = Math.abs((n4 + (bl ? 1 : -1) * n5 * n5) % this.totalSlots);
                    if (!bl) {
                        ++n5;
                    }
                    bl = !bl;
                }
                if (n6 == -1) break;
                n2 = n6;
                break;
            }
            ++n7;
        }
        this.keys[n] = object;
        this.reverse[n2] = (short)n;
        this.inodes[n] = (short)n7;
        if (this.mru != -1) {
            this.prev[n] = this.mru;
            this.next[this.mru] = (short)n;
        }
        this.mru = (short)n;
        return (short)n7;
    }

    public Object reverse(short s) {
        short s2;
        int n;
        int n2 = n = s % this.totalSlots;
        int n3 = 1;
        boolean bl = true;
        while ((s2 = this.reverse[n]) != -1) {
            if (this.inodes[s2] == s) {
                return this.keys[s2];
            }
            n = Math.abs((n2 + (bl ? 1 : -1) * n3 * n3) % this.totalSlots);
            if (!bl) {
                ++n3;
            }
            bl = !bl;
        }
        return null;
    }
}

