/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.EmptyStackException;
import java.util.Stack;

public class SelectorFactory {
    public static final int MAX_SELECTORS = 20;
    public static final int MAX_ATTEMPTS = 2;
    private static final Stack<Selector> SELECTORS = new Stack();
    public static final long TIMEOUT = 5000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Selector getSelector() {
        Stack<Selector> stack = SELECTORS;
        synchronized (stack) {
            Selector selector = null;
            try {
                if (SELECTORS.size() != 0) {
                    selector = SELECTORS.pop();
                }
            }
            catch (EmptyStackException ex) {
                // empty catch block
            }
            try {
                for (int attempts = 0; selector == null && attempts < 2; ++attempts) {
                    SELECTORS.wait(5000L);
                    try {
                        if (SELECTORS.size() == 0) continue;
                        selector = SELECTORS.pop();
                        continue;
                    }
                    catch (EmptyStackException ex) {
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return selector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void returnSelector(Selector selector) {
        Stack<Selector> stack = SELECTORS;
        synchronized (stack) {
            SELECTORS.push(selector);
            if (SELECTORS.size() == 1) {
                SELECTORS.notify();
            }
        }
    }

    static {
        try {
            for (int i = 0; i < 20; ++i) {
                SELECTORS.add(Selector.open());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

