/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import jhi.flapjack.gui.table.FilterColumn;
import scri.commons.gui.RB;

class FilterDialogTableModel
extends AbstractTableModel {
    private FilterColumn[] data;
    private ArrayList<FilterColumn> rows;
    private String[] columnNames;

    FilterDialogTableModel(FilterColumn[] data, FilterColumn[] lastUsed) {
        this.data = data;
        this.columnNames = new String[]{RB.getString((String)"gui.table.FilterDialog.col1"), RB.getString((String)"gui.table.FilterDialog.col2"), RB.getString((String)"gui.table.FilterDialog.col3")};
        this.rows = new ArrayList();
        FilterColumn[] colsToAdd = data;
        if (lastUsed != null) {
            colsToAdd = lastUsed;
        }
        for (FilterColumn entry : colsToAdd) {
            this.rows.add(entry);
        }
    }

    FilterColumn[] getResults() {
        return this.rows.toArray(new FilterColumn[0]);
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    void setColumnName(int col, String name) {
        this.columnNames[col] = name;
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.rows.get((int)row).name;
        }
        if (col == 1) {
            return this.rows.get(row);
        }
        return this.rows.get(row).getValue();
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return String.class;
        }
        if (col == 1) {
            return FilterColumn.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1 || col == 2 && !this.needsBooleanFilter(row);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        FilterColumn entry = this.rows.get(row);
        if (col == 1) {
            entry.setFilter(((FilterColumn)value).getFilter());
        } else if (col == 2) {
            if (((String)value).isEmpty()) {
                entry.setValue(null);
            } else {
                try {
                    Double.parseDouble((String)value);
                    entry.setValue((String)value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    boolean needsBooleanFilter(int row) {
        return this.rows.get(row).isBoolFilter();
    }

    void clear() {
        for (FilterColumn entry : this.rows) {
            entry.setFilter(0);
            entry.setValue(null);
        }
        this.fireTableDataChanged();
    }
}

