/*
 * Decompiled with CFR 0.152.
 */
package jhi.brapi.api.files;

import java.io.File;
import org.restlet.data.Disposition;
import org.restlet.data.MediaType;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class Files
extends ServerResource {
    private String filename;

    protected void doInit() throws ResourceException {
        super.doInit();
        this.filename = (String)this.getRequestAttributes().get("filename");
    }

    @Get(value="tsv")
    public Representation getTsv() {
        return this.getFile(MediaType.TEXT_TSV);
    }

    @Get(value="png")
    public Representation getPng() {
        return this.getFile(MediaType.IMAGE_PNG);
    }

    private Representation getFile(MediaType mediaType) {
        File file = new File(System.getProperty("java.io.tmpdir"), this.filename);
        if (file.exists()) {
            FileRepresentation fileRepresentation = new FileRepresentation(file, mediaType);
            Disposition disp = new Disposition("attachment");
            disp.setFilename(file.getName());
            disp.setSize(file.length());
            fileRepresentation.setDisposition(disp);
            fileRepresentation.setAutoDeleting(true);
            return fileRepresentation;
        }
        throw new ResourceException(404);
    }
}

