/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.servlet.api;

import java.util.List;
import java.util.logging.Logger;
import jhi.flapjack.servlet.api.IScheduler;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.JobTemplate;
import org.ggf.drmaa.Session;
import org.ggf.drmaa.SessionFactory;

public class DRMAAScheduler
implements IScheduler {
    private Logger LOG;
    public static Session session;

    @Override
    public void initialize() {
        this.LOG = Logger.getLogger(DRMAAScheduler.class.getName());
        try {
            if (session == null) {
                SessionFactory factory = SessionFactory.getFactory();
                session = factory.getSession();
                session.init(null);
            }
        }
        catch (DrmaaException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() throws DrmaaException {
        if (session != null) {
            session.exit();
        }
    }

    @Override
    public String submit(String command, List<String> args, String wrkDir) throws DrmaaException {
        JobTemplate jt = session.createJobTemplate();
        jt.setRemoteCommand(command);
        jt.setArgs(args);
        jt.setWorkingDirectory(wrkDir.toString());
        return session.runJob(jt);
    }

    @Override
    public boolean isJobFinished(String id) throws Exception {
        int status = session.getJobProgramStatus(id);
        switch (status) {
            case 48: {
                this.LOG.info("## DRMAA Job " + id + " is DONE");
                return true;
            }
            case 0: 
            case 64: {
                this.LOG.severe("## DRMAA Job " + id + " UNDETERMINED OR FAILED");
                throw new Exception("Job " + id + " undetermined or failed");
            }
        }
        this.LOG.info("## DRMAA Job " + id + " is " + status);
        return false;
    }

    @Override
    public void cancelJob(String id) throws DrmaaException {
        session.control(id, 4);
        this.LOG.info("Cancelled job with ID " + id);
    }
}

