/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.StreamAllocation;
import okhttp3.internal.framed.ErrorCode;
import okhttp3.internal.framed.FramedConnection;
import okhttp3.internal.framed.FramedStream;
import okhttp3.internal.framed.Header;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.HttpStream;
import okhttp3.internal.http.RealResponseBody;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okio.ByteString;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class Http2xStream
implements HttpStream {
    private static final ByteString CONNECTION = ByteString.encodeUtf8((String)"connection");
    private static final ByteString HOST = ByteString.encodeUtf8((String)"host");
    private static final ByteString KEEP_ALIVE = ByteString.encodeUtf8((String)"keep-alive");
    private static final ByteString PROXY_CONNECTION = ByteString.encodeUtf8((String)"proxy-connection");
    private static final ByteString TRANSFER_ENCODING = ByteString.encodeUtf8((String)"transfer-encoding");
    private static final ByteString TE = ByteString.encodeUtf8((String)"te");
    private static final ByteString ENCODING = ByteString.encodeUtf8((String)"encoding");
    private static final ByteString UPGRADE = ByteString.encodeUtf8((String)"upgrade");
    private static final List<ByteString> SPDY_3_SKIPPED_REQUEST_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TRANSFER_ENCODING, Header.TARGET_METHOD, Header.TARGET_PATH, Header.TARGET_SCHEME, Header.TARGET_AUTHORITY, Header.TARGET_HOST, Header.VERSION);
    private static final List<ByteString> SPDY_3_SKIPPED_RESPONSE_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TRANSFER_ENCODING);
    private static final List<ByteString> HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE, Header.TARGET_METHOD, Header.TARGET_PATH, Header.TARGET_SCHEME, Header.TARGET_AUTHORITY, Header.TARGET_HOST, Header.VERSION);
    private static final List<ByteString> HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE);
    private final OkHttpClient client;
    private final StreamAllocation streamAllocation;
    private final FramedConnection framedConnection;
    private FramedStream stream;

    public Http2xStream(OkHttpClient client, StreamAllocation streamAllocation, FramedConnection framedConnection) {
        this.client = client;
        this.streamAllocation = streamAllocation;
        this.framedConnection = framedConnection;
    }

    @Override
    public Sink createRequestBody(Request request, long contentLength) {
        return this.stream.getSink();
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        if (this.stream != null) {
            return;
        }
        boolean permitsRequestBody = HttpMethod.permitsRequestBody(request.method());
        List<Header> requestHeaders = this.framedConnection.getProtocol() == Protocol.HTTP_2 ? Http2xStream.http2HeadersList(request) : Http2xStream.spdy3HeadersList(request);
        boolean hasResponseBody = true;
        this.stream = this.framedConnection.newStream(requestHeaders, permitsRequestBody, hasResponseBody);
        this.stream.readTimeout().timeout((long)this.client.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.stream.writeTimeout().timeout((long)this.client.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public Response.Builder readResponseHeaders() throws IOException {
        return this.framedConnection.getProtocol() == Protocol.HTTP_2 ? Http2xStream.readHttp2HeadersList(this.stream.getResponseHeaders()) : Http2xStream.readSpdy3HeadersList(this.stream.getResponseHeaders());
    }

    public static List<Header> spdy3HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<Header> result = new ArrayList<Header>(headers.size() + 5);
        result.add(new Header(Header.TARGET_METHOD, request.method()));
        result.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.url())));
        result.add(new Header(Header.VERSION, "HTTP/1.1"));
        result.add(new Header(Header.TARGET_HOST, Util.hostHeader(request.url(), false)));
        result.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
        LinkedHashSet<ByteString> names = new LinkedHashSet<ByteString>();
        int size = headers.size();
        block0: for (int i = 0; i < size; ++i) {
            ByteString name = ByteString.encodeUtf8((String)headers.name(i).toLowerCase(Locale.US));
            if (SPDY_3_SKIPPED_REQUEST_HEADERS.contains(name)) continue;
            String value = headers.value(i);
            if (names.add(name)) {
                result.add(new Header(name, value));
                continue;
            }
            for (int j = 0; j < result.size(); ++j) {
                if (!((Header)result.get((int)j)).name.equals((Object)name)) continue;
                String concatenated = Http2xStream.joinOnNull(((Header)result.get((int)j)).value.utf8(), value);
                result.set(j, new Header(name, concatenated));
                continue block0;
            }
        }
        return result;
    }

    private static String joinOnNull(String first, String second) {
        return first + '\u0000' + second;
    }

    public static List<Header> http2HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<Header> result = new ArrayList<Header>(headers.size() + 4);
        result.add(new Header(Header.TARGET_METHOD, request.method()));
        result.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.url())));
        result.add(new Header(Header.TARGET_AUTHORITY, Util.hostHeader(request.url(), false)));
        result.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            ByteString name = ByteString.encodeUtf8((String)headers.name(i).toLowerCase(Locale.US));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(name)) continue;
            result.add(new Header(name, headers.value(i)));
        }
        return result;
    }

    public static Response.Builder readSpdy3HeadersList(List<Header> headerBlock) throws IOException {
        String status = null;
        String version = "HTTP/1.1";
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headerBlock.size();
        for (int i = 0; i < size; ++i) {
            ByteString name = headerBlock.get((int)i).name;
            String values = headerBlock.get((int)i).value.utf8();
            int start = 0;
            while (start < values.length()) {
                int end = values.indexOf(0, start);
                if (end == -1) {
                    end = values.length();
                }
                String value = values.substring(start, end);
                if (name.equals((Object)Header.RESPONSE_STATUS)) {
                    status = value;
                } else if (name.equals((Object)Header.VERSION)) {
                    version = value;
                } else if (!SPDY_3_SKIPPED_RESPONSE_HEADERS.contains(name)) {
                    Internal.instance.addLenient(headersBuilder, name.utf8(), value);
                }
                start = end + 1;
            }
        }
        if (status == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        StatusLine statusLine = StatusLine.parse(version + " " + status);
        return new Response.Builder().protocol(Protocol.SPDY_3).code(statusLine.code).message(statusLine.message).headers(headersBuilder.build());
    }

    public static Response.Builder readHttp2HeadersList(List<Header> headerBlock) throws IOException {
        String status = null;
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headerBlock.size();
        for (int i = 0; i < size; ++i) {
            ByteString name = headerBlock.get((int)i).name;
            String value = headerBlock.get((int)i).value.utf8();
            if (name.equals((Object)Header.RESPONSE_STATUS)) {
                status = value;
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(name)) continue;
            Internal.instance.addLenient(headersBuilder, name.utf8(), value);
        }
        if (status == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        StatusLine statusLine = StatusLine.parse("HTTP/1.1 " + status);
        return new Response.Builder().protocol(Protocol.HTTP_2).code(statusLine.code).message(statusLine.message).headers(headersBuilder.build());
    }

    @Override
    public ResponseBody openResponseBody(Response response) throws IOException {
        StreamFinishingSource source = new StreamFinishingSource(this.stream.getSource());
        return new RealResponseBody(response.headers(), Okio.buffer((Source)source));
    }

    @Override
    public void cancel() {
        if (this.stream != null) {
            this.stream.closeLater(ErrorCode.CANCEL);
        }
    }

    class StreamFinishingSource
    extends ForwardingSource {
        public StreamFinishingSource(Source delegate) {
            super(delegate);
        }

        public void close() throws IOException {
            Http2xStream.this.streamAllocation.streamFinished(false, Http2xStream.this);
            super.close();
        }
    }
}

