/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.undo;

import java.util.ArrayList;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.IUndoState;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.table.FilterColumn;
import jhi.flapjack.gui.table.SortColumn;

public class HidLinesState
implements IUndoState {
    private GTViewSet viewSet;
    private String menuStr;
    private ArrayList<LineInfo> undoVisible;
    private ArrayList<LineInfo> undoHidden;
    private ArrayList<LineInfo> undoFiltered;
    private ArrayList<LineInfo> redoVisible;
    private ArrayList<LineInfo> redoHidden;
    private ArrayList<LineInfo> redoFiltered;
    private ArrayList<SortColumn> undoSort;
    private ArrayList<SortColumn> redoSort;
    private FilterColumn[] undoFilter;
    private FilterColumn[] redoFilter;

    public HidLinesState(GTViewSet viewSet, String menuStr) {
        this.viewSet = viewSet;
        this.menuStr = menuStr;
    }

    @Override
    public String getMenuString() {
        return this.menuStr;
    }

    public void setMenuString(String menuStr) {
        this.menuStr = menuStr;
    }

    @Override
    public GTView getView() {
        return null;
    }

    @Override
    public void createUndoState() {
        this.undoVisible = this.viewSet.copyLines(LineInfo.VISIBLE);
        this.undoHidden = this.viewSet.copyLines(LineInfo.HIDDEN);
        this.undoFiltered = this.viewSet.copyLines(LineInfo.FILTERED);
        this.undoSort = this.viewSet.tableHandler().getSortKeys();
        this.undoFilter = this.viewSet.tableHandler().getTableFilter();
    }

    @Override
    public void applyUndoState() {
        this.viewSet.setLinesFromCopies(this.undoVisible, this.undoHidden, this.undoFiltered);
        this.viewSet.tableHandler().undoRedoApplySort(this.undoSort);
        this.viewSet.tableHandler().undoRedoApplyFilter(this.undoFilter);
    }

    @Override
    public void createRedoState() {
        this.redoVisible = this.viewSet.copyLines(LineInfo.VISIBLE);
        this.redoHidden = this.viewSet.copyLines(LineInfo.HIDDEN);
        this.redoFiltered = this.viewSet.copyLines(LineInfo.FILTERED);
        this.redoSort = this.viewSet.tableHandler().getSortKeys();
        this.redoFilter = this.viewSet.tableHandler().getTableFilter();
    }

    @Override
    public void applyRedoState() {
        this.viewSet.setLinesFromCopies(this.redoVisible, this.redoHidden, this.redoFiltered);
        this.viewSet.tableHandler().undoRedoApplySort(this.redoSort);
        this.viewSet.tableHandler().undoRedoApplyFilter(this.redoFilter);
    }
}

