/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.IOverlayRenderer;

class GenotypeCanvasInfoPane
implements IOverlayRenderer {
    private GenotypePanel gPanel;
    private GenotypeCanvas canvas;
    private Color bgColor;
    private Font titleFont;
    private Font labelFont;
    private FontMetrics fmTitle;
    private Point mouse;
    private int x;
    private int y;
    private int w;
    private int lineSpacing = 15;
    private int yPos;

    GenotypeCanvasInfoPane(GenotypePanel gPanel, GenotypeCanvas canvas) {
        this.gPanel = gPanel;
        this.canvas = canvas;
        Color c = (Color)UIManager.get("info");
        this.bgColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), 190);
        this.titleFont = new Font("Dialog", 1, 12);
        this.labelFont = new Font("Dialog", 0, 11);
        BufferedImage image = new BufferedImage(1, 1, 1);
        Graphics g = ((Image)image).getGraphics();
        this.fmTitle = g.getFontMetrics(this.titleFont);
        g.dispose();
    }

    public void setMousePosition(Point mouse) {
        this.mouse = mouse;
    }

    @Override
    public void render(Graphics2D g) {
        GTView view = this.gPanel.getView();
        int line = view.mouseOverLine;
        int mrkr = view.mouseOverMarker;
        if (this.mouse == null || line == -1 || mrkr == -1) {
            return;
        }
        this.w = 300;
        this.yPos = 0;
        this.calculatePosition(75);
        g.translate(this.x, this.y);
        this.drawBoxBackground(g, 75);
        g.setColor(Color.black);
        g.setFont(this.labelFont);
        g.drawString(mrkr + "," + line, 20, 20);
        g.translate(-this.x, -this.y);
    }

    private void drawBoxBackground(Graphics2D g, int h) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.bgColor);
        g.fillRoundRect(0, this.yPos, this.w - 1, h - 1, 10, 10);
        g.setColor(Color.black);
        g.drawRoundRect(0, this.yPos, this.w - 1, h - 1, 10, 10);
        this.yPos += 15;
    }

    private void calculatePosition(int h) {
        this.x = this.mouse.x + 15;
        this.y = this.mouse.y + 20;
        int pX2Max = this.canvas.pX2Max;
        int pY2 = this.canvas.pY2Max;
        if (this.x + this.w >= pX2Max) {
            this.x = pX2Max - this.w - 1;
        }
        if (this.y + h >= pY2) {
            this.y = pY2 - h - 1;
        }
    }
}

