/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.importer;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.importer.ImportGenoAdvDialog;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;
import scri.commons.gui.matisse.HistoryComboBox;

class ImportGenoTabNB
extends JPanel
implements ActionListener {
    private JDialog parent;
    private JPanel filePanel;
    private JButton genoButton;
    HistoryComboBox genoComboBox;
    private JLabel genoLabel;
    private JButton hdf5Button;
    HistoryComboBox hdf5ComboBox;
    private JLabel hdf5Label;
    private JButton mapButton;
    HistoryComboBox mapComboBox;
    private JLabel mapLabel;
    private JButton optionsButton;
    private JLabel optionsLabel;
    private JPanel optionsPanel;
    private JLabel tabLabel;
    private JRadioButton useHDF5;
    private JRadioButton useText;

    ImportGenoTabNB(JDialog parent) {
        this.initComponents();
        this.parent = parent;
        this.setBackground((Color)UIManager.get("fjDialogBG"));
        this.filePanel.setBackground((Color)UIManager.get("fjDialogBG"));
        this.optionsPanel.setBackground((Color)UIManager.get("fjDialogBG"));
        this.mapButton.addActionListener(this);
        this.genoButton.addActionListener(this);
        this.hdf5Button.addActionListener(this);
        this.optionsButton.addActionListener(this);
        this.mapComboBox.setHistory(Prefs.guiMapList);
        this.genoComboBox.setHistory(Prefs.guiGenoList);
        this.hdf5ComboBox.setHistory(Prefs.guiHDF5List);
        if (Prefs.guiMapListUseBlank) {
            this.mapComboBox.getEditor().setItem("");
        }
        RB.setText((JLabel)this.tabLabel, (String)"gui.dialog.NBDataImportPanel.tabLabel");
        this.filePanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.NBDataImportPanel.filePanel")));
        RB.setText((AbstractButton)this.useText, (String)"gui.dialog.NBDataImportPanel.useText");
        RB.setText((JLabel)this.mapLabel, (String)"gui.dialog.NBDataImportPanel.mapLabel");
        this.mapButton.setText(RB.getString((String)"gui.text.browse"));
        RB.setText((JLabel)this.genoLabel, (String)"gui.dialog.NBDataImportPanel.genoLabel");
        this.genoButton.setText(RB.getString((String)"gui.text.browse"));
        RB.setText((AbstractButton)this.useHDF5, (String)"gui.dialog.NBDataImportPanel.useHDF5");
        RB.setText((JLabel)this.hdf5Label, (String)"gui.dialog.NBDataImportPanel.hdf5Label");
        this.hdf5Button.setText(RB.getString((String)"gui.text.browse"));
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.NBDataImportPanel.optionsPanel")));
        RB.setText((JLabel)this.optionsLabel, (String)"gui.dialog.NBDataImportPanel.optionsLabel");
        RB.setText((AbstractButton)this.optionsButton, (String)"gui.dialog.NBDataImportPanel.optionsButton");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.useText);
        bg.add(this.useHDF5);
        this.useText.setSelected(Prefs.guiImportType == 0);
        this.useHDF5.setSelected(Prefs.guiImportType == 2);
        this.setStates();
        this.mapComboBox.addActionListener((ActionListener)this);
        this.genoComboBox.addActionListener((ActionListener)this);
        this.hdf5ComboBox.addActionListener((ActionListener)this);
        this.useText.addActionListener(this);
        this.useHDF5.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mapButton) {
            this.browse(this.mapComboBox);
        } else if (e.getSource() == this.genoButton) {
            this.browse(this.genoComboBox);
        } else if (e.getSource() == this.hdf5Button) {
            this.browse(this.hdf5ComboBox);
        } else if (e.getSource() == this.useText || e.getSource() == this.useHDF5) {
            this.setStates();
        } else if (e.getSource() == this.optionsButton) {
            new ImportGenoAdvDialog(this.parent);
        }
    }

    private void setStates() {
        Prefs.guiImportType = this.useHDF5.isSelected() ? 2 : 0;
        this.mapLabel.setEnabled(this.useText.isSelected());
        this.mapComboBox.setEnabled(this.useText.isSelected());
        this.mapButton.setEnabled(this.useText.isSelected());
        this.genoLabel.setEnabled(this.useText.isSelected());
        this.genoComboBox.setEnabled(this.useText.isSelected());
        this.genoButton.setEnabled(this.useText.isSelected());
        this.hdf5Label.setEnabled(this.useHDF5.isSelected());
        this.hdf5ComboBox.setEnabled(this.useHDF5.isSelected());
        this.hdf5Button.setEnabled(this.useHDF5.isSelected());
    }

    private void browse(HistoryComboBox combo) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(RB.getString((String)"gui.dialog.NBDataImportPanel.fcTitle"));
        fc.setCurrentDirectory(new File(Prefs.guiCurrentDir));
        if (combo.getText().length() > 0) {
            fc.setCurrentDirectory(new File(combo.getText()));
        }
        if (fc.showOpenDialog(this) == 0) {
            File file = fc.getSelectedFile();
            Prefs.guiCurrentDir = fc.getCurrentDirectory().toString();
            combo.updateComboBox(file.toString());
        }
    }

    boolean isOK() {
        if (this.useText.isSelected() && this.genoComboBox.getText().length() == 0) {
            TaskDialog.warning((String)RB.getString((String)"gui.dialog.NBDataImportPanel.warn1"), (String)RB.getString((String)"gui.text.ok"));
            return false;
        }
        if (this.useHDF5.isSelected() && this.hdf5ComboBox.getText().length() == 0) {
            TaskDialog.warning((String)RB.getString((String)"gui.dialog.NBDataImportPanel.warn2"), (String)RB.getString((String)"gui.text.ok"));
            return false;
        }
        Prefs.guiMapList = this.mapComboBox.getHistory();
        Prefs.guiGenoList = this.genoComboBox.getHistory();
        Prefs.guiHDF5List = this.hdf5ComboBox.getHistory();
        return true;
    }

    File getMapFile() {
        if (!this.mapComboBox.getText().isEmpty()) {
            Prefs.guiMapListUseBlank = false;
            return new File(this.mapComboBox.getText());
        }
        Prefs.guiMapListUseBlank = true;
        return null;
    }

    File getGenotypeFile() {
        return new File(this.genoComboBox.getText());
    }

    File getHDF5File() {
        return new File(this.hdf5ComboBox.getText());
    }

    private void initComponents() {
        this.filePanel = new JPanel();
        this.useText = new JRadioButton();
        this.mapLabel = new JLabel();
        this.mapComboBox = new HistoryComboBox();
        this.mapButton = new JButton();
        this.genoLabel = new JLabel();
        this.genoComboBox = new HistoryComboBox();
        this.genoButton = new JButton();
        this.useHDF5 = new JRadioButton();
        this.hdf5ComboBox = new HistoryComboBox();
        this.hdf5Label = new JLabel();
        this.hdf5Button = new JButton();
        this.tabLabel = new JLabel();
        this.optionsPanel = new JPanel();
        this.optionsButton = new JButton();
        this.optionsLabel = new JLabel();
        this.filePanel.setBorder(BorderFactory.createTitledBorder("Data files to import:"));
        this.useText.setText("Import from text files");
        this.mapLabel.setLabelFor((Component)this.mapComboBox);
        this.mapLabel.setText("Map file (optional):");
        this.mapButton.setText("Browse...");
        this.genoLabel.setLabelFor((Component)this.genoComboBox);
        this.genoLabel.setText("Genotype file:");
        this.genoButton.setText("Browse...");
        this.useHDF5.setText("Import from an HDF5 file");
        this.hdf5Label.setLabelFor((Component)this.hdf5ComboBox);
        this.hdf5Label.setText("HDF5 file:");
        this.hdf5Button.setText("Browse...");
        GroupLayout filePanelLayout = new GroupLayout(this.filePanel);
        this.filePanel.setLayout(filePanelLayout);
        filePanelLayout.setHorizontalGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filePanelLayout.createSequentialGroup().addContainerGap().addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filePanelLayout.createSequentialGroup().addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useHDF5).addComponent(this.useText)).addGap(0, 0, Short.MAX_VALUE)).addGroup(filePanelLayout.createSequentialGroup().addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(filePanelLayout.createSequentialGroup().addComponent(this.hdf5Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.hdf5ComboBox, -1, -1, Short.MAX_VALUE)).addGroup(filePanelLayout.createSequentialGroup().addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.genoLabel).addComponent(this.mapLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.mapComboBox, -1, -1, Short.MAX_VALUE).addComponent((Component)this.genoComboBox, -1, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.genoButton, GroupLayout.Alignment.TRAILING).addComponent(this.mapButton, GroupLayout.Alignment.TRAILING).addComponent(this.hdf5Button, GroupLayout.Alignment.TRAILING)))).addContainerGap()));
        filePanelLayout.linkSize(0, this.hdf5Label, this.mapLabel);
        filePanelLayout.setVerticalGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, filePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.useText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.mapLabel).addComponent(this.mapButton).addComponent((Component)this.mapComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.genoLabel).addComponent(this.genoButton).addComponent((Component)this.genoComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.useHDF5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hdf5Label).addComponent((Component)this.hdf5ComboBox, -2, -1, -2).addComponent(this.hdf5Button)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabLabel.setText("Use this tab to import map and genotype data into a new or existing Flapjack project.");
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder("Advanced options:"));
        this.optionsButton.setText("Advanced options...");
        this.optionsLabel.setText("Edit the advanced options to adjust how Flapjack will process the files being imported.");
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsLabel).addComponent(this.optionsButton)).addContainerGap(-1, Short.MAX_VALUE)));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.optionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optionsButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.optionsPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.tabLabel, GroupLayout.Alignment.LEADING).addComponent(this.filePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabLabel).addGap(18, 18, 18).addComponent(this.filePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optionsPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

