/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public class SAX2DOMHandler
extends HandlerBase {
    private final Node _node;
    private final Stack<Element> _parents = new Stack();

    public SAX2DOMHandler(Node node) {
        this._node = node;
    }

    @Override
    public void startElement(String name, AttributeList attributes) {
        Node parent = !this._parents.isEmpty() ? (Node)this._parents.peek() : this._node;
        Document document = this.getDocument(parent);
        Element element = document.createElement(name);
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            element.setAttribute(attributes.getName(i), attributes.getValue(i));
        }
        parent.appendChild(element);
        this._parents.push(element);
    }

    @Override
    public void characters(char[] chars, int offset, int length) {
        String data = new String(chars, offset, length);
        Node parent = !this._parents.isEmpty() ? (Node)this._parents.peek() : this._node;
        Node last = parent.getLastChild();
        if (last != null && last.getNodeType() == 3) {
            ((Text)last).appendData(data);
        } else {
            Text text = parent.getOwnerDocument().createTextNode(data);
            parent.appendChild(text);
        }
    }

    @Override
    public void endElement(String name) {
        this._parents.pop();
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        Document document = this.getDocument(this._node);
        ProcessingInstruction instruction = document.createProcessingInstruction(target, data);
        document.insertBefore(instruction, document.getFirstChild());
    }

    private Document getDocument(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        return document;
    }
}

