/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import jhi.flapjack.data.Project;
import jhi.flapjack.data.XMLRoot;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.io.DataFormatException;
import jhi.flapjack.io.FlapjackFile;
import jhi.flapjack.io.ProjectSerializerDB;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;
import scri.commons.io.FileUtils;

public class ProjectSerializer {
    public static int XMLZ = 0;
    public static int XML = 1;
    private static Mapping mapping;
    private static boolean isDB;
    private static File oldFile;
    private static File newFile;

    private static void initialize() throws Exception {
        mapping = new Mapping();
        mapping.loadMapping(new ProjectSerializer().getClass().getResource("/config/flapjack-castor.xml"));
    }

    public static boolean querySave(Project project, boolean saveAs) {
        FlapjackFile fjFile = project.fjFile;
        if (fjFile == null || fjFile.isURL() || !fjFile.getFile().canWrite()) {
            saveAs = true;
        }
        if (saveAs && !ProjectSerializer.showSaveAsDialog(project)) {
            return false;
        }
        newFile = null;
        oldFile = null;
        if (fjFile != null && !fjFile.getPath().equals(project.fjFile.getPath())) {
            oldFile = fjFile.getFile();
            newFile = project.fjFile.getFile();
        }
        return true;
    }

    public static boolean save(Project project) {
        FlapjackFile fjFile = project.fjFile;
        try {
            long s = System.currentTimeMillis();
            if (oldFile != null && newFile != null) {
                Files.copy(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING, LinkOption.NOFOLLOW_LINKS);
                newFile.setWritable(true);
            }
            ProjectSerializerDB.initConnection(fjFile, true);
            ProjectSerializerDB.initDatabase();
            OutputStream os = ProjectSerializerDB.getProjectOutputStream();
            ProjectSerializer.initialize();
            BufferedWriter cOut = null;
            cOut = System.getenv("FJ_DEBUG") != null && System.getenv("FJ_DEBUG").equalsIgnoreCase("TRUE") ? new BufferedWriter(new FileWriter(fjFile.getFile())) : new BufferedWriter(new OutputStreamWriter(os));
            Marshaller marshaller = new Marshaller((Writer)cOut);
            marshaller.setValidation(false);
            marshaller.setMapping(mapping);
            marshaller.marshal((Object)project);
            cOut.close();
            long t1 = System.currentTimeMillis();
            ProjectSerializerDB.cacheToDatabase();
            long t2 = System.currentTimeMillis();
            System.out.println("DB Serialization Cache: " + (t2 - t1) + "ms");
            long e = System.currentTimeMillis();
            System.out.println("Project saved in " + (e - s) + "ms");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            TaskDialog.error((String)RB.format((String)"io.ProjectSerializer.saveError", (Object[])new Object[]{fjFile.getName(), e}), (String)RB.getString((String)"gui.text.close"));
            return false;
        }
    }

    public static FlapjackFile queryOpen(FlapjackFile file) {
        if (file == null && (file = ProjectSerializer.showOpenDialog()) == null) {
            return null;
        }
        return file;
    }

    public static Project open(FlapjackFile file) {
        Project project = null;
        try {
            long s = System.currentTimeMillis();
            XMLRoot.reset();
            ProjectSerializer.initialize();
            BufferedReader in = null;
            if (ProjectSerializer.determineFormat(file) == XMLZ) {
                ZipInputStream zis = new ZipInputStream(ProjectSerializer.getStream(file));
                zis.getNextEntry();
                in = new BufferedReader(new InputStreamReader(zis));
            } else {
                in = new BufferedReader(new InputStreamReader(ProjectSerializer.getStream(file)));
            }
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            unmarshaller.setIgnoreExtraElements(true);
            unmarshaller.setValidation(false);
            project = (Project)unmarshaller.unmarshal((Reader)in);
            project.fjFile = file;
            in.close();
            long e = System.currentTimeMillis();
            System.out.println("Project opened in " + (e - s) + "ms");
            try {
                project.validate();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return project;
        }
        catch (Exception e) {
            e.printStackTrace();
            TaskDialog.error((String)RB.format((String)"io.ProjectSerializer.openError", (Object[])new Object[]{file.getName(), e.getMessage()}), (String)RB.getString((String)"gui.text.close"));
            return null;
        }
    }

    private static FlapjackFile showOpenDialog() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(RB.getString((String)"io.ProjectSerializer.openDialog"));
        fc.setCurrentDirectory(new File(Prefs.guiCurrentDir));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(RB.getString((String)"other.Filters.project"), "flapjack");
        fc.addChoosableFileFilter(filter);
        if (fc.showOpenDialog(Flapjack.winMain) == 0) {
            File file = fc.getSelectedFile();
            Prefs.guiCurrentDir = fc.getCurrentDirectory().getPath();
            return new FlapjackFile(file.getPath());
        }
        return null;
    }

    private static boolean showSaveAsDialog(Project project) {
        FlapjackFile fjFile = project.fjFile;
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(RB.getString((String)"io.ProjectSerializer.saveDialog"));
        fc.setAcceptAllFileFilterUsed(false);
        if (fjFile != null) {
            if (fjFile.isURL()) {
                fc.setSelectedFile(new File(Prefs.guiCurrentDir, fjFile.getName()));
            } else {
                fc.setSelectedFile(fjFile.getFile());
            }
        } else {
            fc.setSelectedFile(new File(Prefs.guiCurrentDir, "Flapjack " + Prefs.guiProjectCount + ".flapjack"));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter(RB.getString((String)"other.Filters.project"), "flapjack");
        fc.addChoosableFileFilter(filter);
        while (fc.showSaveDialog(Flapjack.winMain) == 0) {
            File file = fc.getSelectedFile();
            if (!file.exists() && file.getName().indexOf(".") == -1) {
                file = new File(file.getPath() + "." + filter.getExtensions()[0]);
            }
            if (file.exists()) {
                String[] options;
                String msg = RB.format((String)"io.ProjectSerializer.confirm", (Object[])new Object[]{file});
                int response = TaskDialog.show((String)msg, (int)2, (int)1, (String[])(options = new String[]{RB.getString((String)"io.ProjectSerializer.overwrite"), RB.getString((String)"io.ProjectSerializer.rename"), RB.getString((String)"gui.text.cancel")}));
                if (response == 1) continue;
                if (response == -1 || response == 2) {
                    return false;
                }
            }
            Prefs.guiCurrentDir = fc.getCurrentDirectory().getPath();
            ++Prefs.guiProjectCount;
            project.fjFile = new FlapjackFile(file.getPath());
            return true;
        }
        return false;
    }

    public static boolean okToContinue(Project project, boolean useExitMessage) {
        if (project != null && Actions.fileSave.isEnabled()) {
            String[] options;
            String msg = null;
            msg = useExitMessage ? RB.getString((String)"io.ProjectSerializer.notSavedExit") : RB.getString((String)"io.ProjectSerializer.notSaved");
            int response = TaskDialog.show((String)msg, (int)2, (int)0, (String[])(options = new String[]{RB.getString((String)"io.ProjectSerializer.save"), RB.getString((String)"io.ProjectSerializer.dontSave"), RB.getString((String)"gui.text.cancel")}));
            if (response == 0) {
                return Flapjack.winMain.mFile.fileSave(false);
            }
            if (response == 1) {
                return true;
            }
            if (response == -1 || response == 2) {
                return false;
            }
        }
        return true;
    }

    private static InputStream getStream(FlapjackFile file) throws IOException {
        if (isDB) {
            if (file.isURL()) {
                File wrkDir = FileUtils.getTempUserDirectory((String)"jhi-flapjack");
                wrkDir = new File(wrkDir, "db-project");
                wrkDir.mkdirs();
                File output = new File(wrkDir, "temp.flapjack");
                try (BufferedInputStream in = new BufferedInputStream(file.getURL().openStream());
                     FileOutputStream out = new FileOutputStream(output);){
                    int count;
                    byte[] data = new byte[1024];
                    while ((count = in.read(data, 0, 1024)) != -1) {
                        out.write(data, 0, count);
                    }
                    file = new FlapjackFile(output.getAbsolutePath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                ProjectSerializerDB.initConnection(file, false);
                return ProjectSerializerDB.getProjectInputStream();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        return file.getInputStream();
    }

    private static int determineFormat(FlapjackFile file) throws DataFormatException, IOException {
        isDB = ProjectSerializerDB.isDatabase(file);
        try {
            ZipInputStream zis = new ZipInputStream(ProjectSerializer.getStream(file));
            ZipEntry entry = zis.getNextEntry();
            System.out.println("got entry: " + entry);
            if (entry != null && entry.getName().equals("flapjack.xml")) {
                return XMLZ;
            }
        }
        catch (ZipException zis) {
        }
        catch (IOException e) {
            throw e;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(ProjectSerializer.getStream(file)));
            String str = in.readLine();
            in.close();
            if (str.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
                return XML;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new DataFormatException(RB.getString((String)"io.DataFormatException.unreadable"));
    }

    static {
        isDB = false;
    }
}

