/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.analysis;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.analysis.ChromosomeSelectionDialog;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.DialogPanel;
import scri.commons.gui.matisse.HyperLinkLabel;

public class MABCStatsDialog
extends JDialog
implements ActionListener {
    private GTViewSet viewSet;
    private ChromosomeSelectionDialog csd;
    private AnalysisSet as;
    private DefaultComboBoxModel<LineInfo> rpModel;
    private DefaultComboBoxModel<LineInfo> dpModel;
    private boolean isOK;
    private JButton bCancel;
    private JButton bHelp;
    private JButton bOK;
    private JRadioButton bUnweighted;
    private JRadioButton bWeighted;
    private HyperLinkLabel csdLabel;
    private JPanel dataPanel;
    private DialogPanel dialogPanel1;
    private JComboBox<LineInfo> donorCombo;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel lblParent1;
    private JLabel lblParent2;
    private JSpinner maxMrkrCoverage;
    private JComboBox<LineInfo> recurrentCombo;
    private JPanel settingsPanel;

    public MABCStatsDialog(GTViewSet viewSet) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.analysis.MABCStatsDialog.title"), true);
        this.viewSet = viewSet;
        this.isOK = false;
        this.as = new AnalysisSet(this.viewSet).withViews(null).withSelectedLines().withSelectedMarkers();
        this.initComponents();
        this.initComponents2();
        FlapjackUtils.initDialog(this, this.bOK, this.bCancel, true, this.getContentPane(), this.settingsPanel, this.dataPanel);
    }

    private void initComponents2() {
        this.maxMrkrCoverage.setValue(Prefs.mabcMaxMrkrCoverage);
        this.bOK.addActionListener(this);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        this.bCancel.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "_-_Marker_Assisted_Back_Crossing");
        this.csd = new ChromosomeSelectionDialog(this.viewSet, true);
        this.csdLabel.addActionListener(e -> this.csd.setVisible(true));
        this.setupComboBoxes(this.as);
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.bWeighted);
        bGroup.add(this.bUnweighted);
        this.bWeighted.addActionListener(this);
        this.bUnweighted.addActionListener(this);
        this.bWeighted.setSelected(!Prefs.guiUseSimpleMabcStats);
        this.bUnweighted.setSelected(Prefs.guiUseSimpleMabcStats);
        this.jLabel3.setEnabled(!Prefs.guiUseSimpleMabcStats);
        this.maxMrkrCoverage.setEnabled(!Prefs.guiUseSimpleMabcStats);
        if (this.viewSet.getView(0).countSelectedLines() < 2) {
            this.bOK.setEnabled(false);
        }
    }

    private void setupComboBoxes(AnalysisSet as) {
        this.rpModel = this.createComboModelFrom(as);
        this.recurrentCombo.setModel(this.rpModel);
        if (as.lineCount() >= 1) {
            this.recurrentCombo.setSelectedIndex(0);
        }
        this.dpModel = this.createComboModelFrom(as);
        this.donorCombo.setModel(this.dpModel);
        if (as.lineCount() >= 2) {
            this.donorCombo.setSelectedIndex(1);
        }
    }

    private DefaultComboBoxModel<LineInfo> createComboModelFrom(AnalysisSet as) {
        DefaultComboBoxModel<LineInfo> model = new DefaultComboBoxModel<LineInfo>();
        for (int i = 0; i < as.lineCount(); ++i) {
            model.addElement(as.getLine(i));
        }
        return model;
    }

    public boolean[] getSelectedChromosomes() {
        return this.csd.getSelectedChromosomes();
    }

    public int getRecurrentParent() {
        return this.recurrentCombo.getSelectedIndex();
    }

    public int getDonorParent() {
        return this.donorCombo.getSelectedIndex();
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOK) {
            Prefs.mabcMaxMrkrCoverage = (Double)this.maxMrkrCoverage.getValue();
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        } else if (e.getSource() == this.bWeighted) {
            this.jLabel3.setEnabled(true);
            this.maxMrkrCoverage.setEnabled(true);
            Prefs.guiUseSimpleMabcStats = this.bUnweighted.isSelected();
        } else if (e.getSource() == this.bUnweighted) {
            this.jLabel3.setEnabled(false);
            this.maxMrkrCoverage.setEnabled(false);
            Prefs.guiUseSimpleMabcStats = this.bUnweighted.isSelected();
        }
    }

    public boolean isSimpleStats() {
        return Prefs.guiUseSimpleMabcStats;
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bOK = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.settingsPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.maxMrkrCoverage = new JSpinner();
        this.lblParent1 = new JLabel();
        this.recurrentCombo = new JComboBox();
        this.lblParent2 = new JLabel();
        this.donorCombo = new JComboBox();
        this.bWeighted = new JRadioButton();
        this.bUnweighted = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.dataPanel = new JPanel();
        this.csdLabel = new HyperLinkLabel();
        this.setDefaultCloseOperation(2);
        this.bOK.setText("Run");
        this.dialogPanel1.add((Component)this.bOK);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("General settings:"));
        this.jLabel3.setText("Maximum coverage per marker (cM): ");
        this.maxMrkrCoverage.setModel(new SpinnerNumberModel((Number)10.0, Double.valueOf(0.0), null, (Number)0.25));
        this.lblParent1.setText("Select recurrent parent line:");
        this.lblParent1.setToolTipText("");
        this.lblParent2.setText("Select donor parent line:");
        this.lblParent2.setToolTipText("");
        this.bWeighted.setText("Weighted model");
        this.bUnweighted.setText("Unweighted model");
        this.jLabel1.setText("<html>Marker Assisted Back Crossing statistics will calculate Recurrent Parent Percentages<br>for each line across each chromosome, and will also display linkage drag and QTL<br>status information if appropriate.");
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bWeighted).addComponent(this.bUnweighted).addGroup(settingsPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxMrkrCoverage, -2, 91, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblParent1).addComponent(this.lblParent2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.donorCombo, 0, -1, Short.MAX_VALUE).addComponent(this.recurrentCombo, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, settingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblParent1).addComponent(this.recurrentCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblParent2).addComponent(this.donorCombo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.bWeighted).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.maxMrkrCoverage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bUnweighted).addContainerGap(-1, Short.MAX_VALUE)));
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data selection settings:"));
        this.csdLabel.setText("Select chromosomes to analyse");
        GroupLayout dataPanelLayout = new GroupLayout(this.dataPanel);
        this.dataPanel.setLayout(dataPanelLayout);
        dataPanelLayout.setHorizontalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.csdLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        dataPanelLayout.setVerticalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.csdLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.dataPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.settingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dialogPanel1, -2, 44, -2)));
        this.pack();
    }
}

