/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.gui;

import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.update.ApplicationDisplayMode;
import com.install4j.api.update.UpdateChecker;
import com.install4j.api.update.UpdateDescriptor;
import com.install4j.api.update.UpdateSchedule;
import com.install4j.api.update.UpdateScheduleRegistry;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Locale;
import javax.swing.SwingUtilities;
import scri.commons.gui.SystemUtils;

public class Install4j {
    public static String VERSION;
    public static final int NEVER = 0;
    public static final int STARTUP = 1;
    public static final int DAILY = 2;
    public static final int WEEKLY = 3;
    public static final int MONTHLY = 4;
    private static String appID;
    private static String updateID;
    private int updateSchedule;
    private String userID;
    private int userRating;
    private String updaterURL;
    private String loggingURL;

    public Install4j(String appID, String updateID) {
        Install4j.appID = appID;
        Install4j.updateID = updateID;
    }

    public void setUser(int updateSchedule, String userID, int userRating) {
        this.updateSchedule = updateSchedule;
        this.userID = userID;
        this.userRating = userRating;
    }

    public void setURLs(String updaterURL, String loggingURL) {
        this.updaterURL = updaterURL;
        this.loggingURL = loggingURL;
    }

    public void doStartUpCheck(Class jarClass) {
        Install4j.getVersion(jarClass);
        this.pingServer();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Install4j.this.checkForUpdate();
            }
        };
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkForUpdate() {
        try {
            switch (this.updateSchedule) {
                case 1: {
                    UpdateScheduleRegistry.setUpdateSchedule((UpdateSchedule)UpdateSchedule.ON_EVERY_START);
                    break;
                }
                case 2: {
                    UpdateScheduleRegistry.setUpdateSchedule((UpdateSchedule)UpdateSchedule.DAILY);
                    break;
                }
                case 3: {
                    UpdateScheduleRegistry.setUpdateSchedule((UpdateSchedule)UpdateSchedule.WEEKLY);
                    break;
                }
                case 4: {
                    UpdateScheduleRegistry.setUpdateSchedule((UpdateSchedule)UpdateSchedule.MONTHLY);
                    break;
                }
                default: {
                    UpdateScheduleRegistry.setUpdateSchedule((UpdateSchedule)UpdateSchedule.NEVER);
                }
            }
            if (!UpdateScheduleRegistry.checkAndReset()) {
                return;
            }
            UpdateDescriptor ud = UpdateChecker.getUpdateDescriptor((String)this.updaterURL, (ApplicationDisplayMode)ApplicationDisplayMode.GUI);
            if (ud.getPossibleUpdateEntry() != null) {
                Install4j.checkForUpdate(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static void checkForUpdate(boolean block) {
        try {
            ApplicationLauncher.launchApplication((String)updateID, null, (boolean)block, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getVersion(Class jarClass) {
        VERSION = jarClass.getPackage().getImplementationVersion();
        if (VERSION == null) {
            VERSION = "x.xx.xx.xx";
        }
        return VERSION;
    }

    private void pingServer() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    String id = URLEncoder.encode(Install4j.this.userID, "UTF-8");
                    String version = URLEncoder.encode(VERSION, "UTF-8");
                    String locale = URLEncoder.encode("" + Locale.getDefault(), "UTF-8");
                    String os = URLEncoder.encode(System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")", "UTF-8");
                    String user = URLEncoder.encode(System.getProperty("user.name"), "UTF-8");
                    String addr = Install4j.this.loggingURL + "?id=" + id + "&version=" + version + "&locale=" + locale + "&rating=" + Install4j.this.userRating + "&os=" + os;
                    if (SystemUtils.isSCRIUser()) {
                        addr = addr + "&user=" + user;
                    }
                    URL url = new URL(addr);
                    HttpURLConnection c = (HttpURLConnection)url.openConnection();
                    c.getResponseCode();
                    c.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        new Thread(r).start();
    }
}

