/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.simmatrix;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.simmatrix.SimMatrixTableModel;
import jhi.flapjack.io.SimMatrixExporter;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.Icons;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class SimMatrixPanelNB
extends JPanel
implements ActionListener {
    private SimMatrixTableModel model;
    private GTViewSet viewSet;
    private SimMatrix matrix;
    private static int mouseRow = -1;
    private static int mouseCol = -1;
    private TableCellRenderer headerRenderer;
    private TableCellRenderer colorHeaderRenderer;
    private JTable rowHeaderTable;
    private static Color headerBG;
    JButton bDendrogram;
    JButton bExport;
    private JButton bPCoA;
    private JTable matrixTable;
    private JScrollPane tableScrollPane;
    private JTabbedPane tabs;
    private JPanel tabsPanel;

    public SimMatrixPanelNB(GTViewSet viewSet, SimMatrix matrix, JScrollPane sp) {
        this.viewSet = viewSet;
        this.matrix = matrix;
        this.initComponents();
        this.model = new SimMatrixTableModel(matrix);
        this.matrixTable.setModel(this.model);
        this.matrixTable.getTableHeader().setReorderingAllowed(false);
        headerBG = UIManager.getColor("TableHeader:\"TableHeader.renderer\"[MouseOver].backgroundPainter");
        this.headerRenderer = this.matrixTable.getTableHeader().getDefaultRenderer();
        this.colorHeaderRenderer = new ColorHeaderRenderer();
        this.matrixTable.getTableHeader().setDefaultRenderer(this.colorHeaderRenderer);
        this.rowHeaderTable = this.createRowHeaderTable(matrix.getLineInfos().size(), 1);
        this.setupRowHeaderTable(matrix);
        this.tableScrollPane.setRowHeaderView(this.rowHeaderTable);
        this.tableScrollPane.setCorner("UPPER_LEFT_CORNER", this.rowHeaderTable.getTableHeader());
        this.tabs.setComponentAt(0, this.tabsPanel.add(sp));
        this.tabs.setTitleAt(0, RB.getString((String)"gui.simmatrix.SimMatrixPanelNB.tab1"));
        this.tabs.setTitleAt(1, RB.getString((String)"gui.simmatrix.SimMatrixPanelNB.tab2"));
        this.bDendrogram.setAction(Actions.alysDendrogram);
        this.bDendrogram.setText(RB.getString((String)"gui.simmatrix.SimMatrixPanelNB.bDendrogram"));
        this.bPCoA.setAction(Actions.alysPCoA);
        this.bPCoA.setText(RB.getString((String)"gui.simmatrix.SimMatrixPanelNB.bPCoA"));
        this.bExport.setText(RB.getString((String)"gui.simmatrix.SimMatrixPanelNB.bExport"));
        this.bExport.setIcon(Icons.getIcon((String)"EXPORTTRAITS"));
        this.bExport.addActionListener(this);
        MouseHandler mh = new MouseHandler();
        this.matrixTable.addMouseListener(mh);
        this.matrixTable.addMouseMotionListener(mh);
    }

    private JTable createTable() {
        return new JTable(){

            @Override
            public TableCellRenderer getCellRenderer(int row, int col) {
                TableCellRenderer tcr = SimMatrixTableModel.getCellRenderer();
                return tcr != null ? tcr : super.getCellRenderer(row, col);
            }
        };
    }

    private JTable createRowHeaderTable(int rows, int cols) {
        return new JTable(rows, cols){

            @Override
            public TableCellRenderer getCellRenderer(int row, int col) {
                return SimMatrixPanelNB.this.colorHeaderRenderer;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
    }

    private void setupRowHeaderTable(SimMatrix matrix) {
        DefaultTableModel rowModel = new DefaultTableModel();
        Object[] objects = new Object[matrix.getLineInfos().size()];
        for (int i = 0; i < matrix.getLineInfos().size(); ++i) {
            objects[i] = matrix.getLineInfos().get(i).name();
        }
        rowModel.addColumn((Object)"", objects);
        this.rowHeaderTable.setModel(rowModel);
        this.rowHeaderTable.setAutoResizeMode(0);
        this.rowHeaderTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.rowHeaderTable.getColumnModel().getColumn(0).setResizable(false);
        this.rowHeaderTable.getTableHeader().setReorderingAllowed(false);
        this.rowHeaderTable.setPreferredScrollableViewportSize(this.rowHeaderTable.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bPCoA) {
            Flapjack.winMain.mAnalysis.principalCordAnalysis();
        } else if (e.getSource() == this.bExport) {
            this.exportSimMatrix();
        }
    }

    private void exportSimMatrix() {
        String name = RB.format((String)"gui.simmatrix.SimMatrixPanelNB.filename", (Object[])new Object[]{this.viewSet.getName()});
        File saveAs = new File(Prefs.guiCurrentDir, name);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(RB.getString((String)"other.Filters.tabtxt"), "txt");
        String filename = FlapjackUtils.getSaveFilename(RB.getString((String)"gui.simmatrix.SimMatrixPanelNB.saveAs"), saveAs, filter);
        if (filename != null) {
            SimMatrixExporter exporter = new SimMatrixExporter(this.matrix, filename);
            ProgressDialog dialog = new ProgressDialog((ITrackableJob)exporter, RB.format((String)"gui.simmatrix.SimMatrixPanelNB.exportTitle", (Object[])new Object[0]), RB.format((String)"gui.simmatrix.SimMatrixPanelNB.exportLabel", (Object[])new Object[0]), (Frame)Flapjack.winMain);
            if (dialog.failed("gui.error")) {
                return;
            }
            TaskDialog.showFileOpen((String)RB.format((String)"gui.simmatrix.SimMatrixPanelNB.exportSuccess", (Object[])new Object[]{filename}), (String)RB.getString((String)"gui.text.open"), (int)1, (File)new File(filename));
        }
    }

    private void initComponents() {
        this.tabs = new JTabbedPane();
        this.tabsPanel = new JPanel();
        this.tableScrollPane = new JScrollPane();
        this.matrixTable = this.createTable();
        this.bDendrogram = new JButton();
        this.bExport = new JButton();
        this.bPCoA = new JButton();
        GroupLayout tabsPanelLayout = new GroupLayout(this.tabsPanel);
        this.tabsPanel.setLayout(tabsPanelLayout);
        tabsPanelLayout.setHorizontalGroup(tabsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 395, Short.MAX_VALUE));
        tabsPanelLayout.setVerticalGroup(tabsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 144, Short.MAX_VALUE));
        this.tabs.addTab("tab1", this.tabsPanel);
        this.matrixTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.matrixTable.setAutoResizeMode(0);
        this.matrixTable.setCursor(new Cursor(0));
        this.matrixTable.setRowSelectionAllowed(false);
        this.tableScrollPane.setViewportView(this.matrixTable);
        this.tabs.addTab("tab2", this.tableScrollPane);
        this.bDendrogram.setText("Create dendrogram");
        this.bExport.setText("Export data");
        this.bPCoA.setText("Create PCoA");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabs, -1, 400, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.bExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDendrogram).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bPCoA).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tabs, -1, 172, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bDendrogram).addComponent(this.bExport).addComponent(this.bPCoA)).addContainerGap()));
    }

    class ColorHeaderRenderer
    extends DefaultTableCellRenderer {
        ColorHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel comp = (JLabel)SimMatrixPanelNB.this.headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table == SimMatrixPanelNB.this.rowHeaderTable && row == mouseRow) {
                comp = (JLabel)SimMatrixPanelNB.this.headerRenderer.getTableCellRendererComponent(table, value, true, hasFocus, row, column);
                comp.setBackground(headerBG);
            } else if (table == SimMatrixPanelNB.this.matrixTable && column == mouseCol) {
                comp = (JLabel)SimMatrixPanelNB.this.headerRenderer.getTableCellRendererComponent(table, value, true, hasFocus, row, column);
            }
            return comp;
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            mouseRow = (mouseCol = -1);
            SimMatrixPanelNB.this.matrixTable.getTableHeader().repaint();
            SimMatrixPanelNB.this.rowHeaderTable.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            mouseRow = SimMatrixPanelNB.this.matrixTable.rowAtPoint(e.getPoint());
            mouseCol = SimMatrixPanelNB.this.matrixTable.columnAtPoint(e.getPoint());
            SimMatrixPanelNB.this.matrixTable.getTableHeader().repaint();
            SimMatrixPanelNB.this.rowHeaderTable.repaint();
        }
    }
}

