/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import jhi.flapjack.analysis.MabcAnalysis;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.gui.mabc.MabcTableModel;
import jhi.flapjack.gui.table.LineDataTable;
import jhi.flapjack.gui.table.LineDataTableExporter;
import jhi.flapjack.io.FlapjackFile;
import jhi.flapjack.io.cmd.CreateProject;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class GenerateMabcStats {
    public static final String WEIGHTED = "weighted";
    public static final String UNWEIGHTED = "unweighted";
    private DataSet dataSet = new DataSet();
    private File mapFile;
    private File genotypesFile;
    private File qtlFile;
    private double maxMarkerCoverage = 10.0;
    private boolean decimalEnglish = false;
    private String filename;
    private boolean unweighted = false;
    private int parent1;
    private int parent2;

    public static void main(String[] args) {
        File mapFile = null;
        File genotypesFile = null;
        File qtlFile = null;
        double maxMarkerCoverage = 10.0;
        String filename = null;
        boolean decimalEnglish = false;
        String modelType = "";
        Integer parent1 = null;
        Integer parent2 = null;
        NumberFormat nf = NumberFormat.getInstance();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-map=")) {
                mapFile = new File(args[i].substring(5));
            }
            if (args[i].startsWith("-genotypes=")) {
                genotypesFile = new File(args[i].substring(11));
            }
            if (args[i].startsWith("-qtls=")) {
                qtlFile = new File(args[i].substring(6));
            }
            if (args[i].startsWith("-parent1=")) {
                parent1 = GenerateMabcStats.parseParent(args[i].substring(9));
            }
            if (args[i].startsWith("-parent2=")) {
                parent2 = GenerateMabcStats.parseParent(args[i].substring(9));
            }
            if (args[i].startsWith("-model=")) {
                modelType = args[i].substring(7);
            }
            if (args[i].startsWith("-coverage=")) {
                try {
                    maxMarkerCoverage = nf.parse(args[i].substring(10)).doubleValue();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (args[i].startsWith("-decimalEnglish")) {
                decimalEnglish = true;
            }
            if (!args[i].startsWith("-output=")) continue;
            filename = args[i].substring(8);
        }
        if (mapFile == null || genotypesFile == null || qtlFile == null || filename == null || parent1 == null || parent2 == null || !modelType.equals(WEIGHTED) && !modelType.equals(UNWEIGHTED)) {
            System.out.println("Usage: mabcstats <options>\n where valid options are:\n   -map=<map_file>                (required input file)\n   -genotypes=<genotypes_file>    (required input file)\n   -qtls=<qtl_file>               (required input file)\n   -parent1=<index_of_line>       (required parameter, index of recurrent parent, first line is index 1)\n   -parent2=<index_of_line>       (required parameter, index of donor parent, first line is index 1)\n   -model=weighted|unweighted     (required parameter)\n   -coverage=<coverage_value>     (optional floating point parameter)\n   -decimalEnglish                (optional parameter)\n   -output=<output_file>          (required output file)");
            System.exit(1);
        }
        GenerateMabcStats mabcStats = new GenerateMabcStats(mapFile, genotypesFile, qtlFile, parent1, parent2, maxMarkerCoverage, filename, decimalEnglish, modelType);
        mabcStats.doStatGeneration();
        System.exit(0);
    }

    private static Integer parseParent(String parent) {
        Integer parentIndex = null;
        try {
            parentIndex = Integer.parseInt(parent) - 1;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return parentIndex;
    }

    public GenerateMabcStats(File mapFile, File genotypesFile, File qtlFile, int parent1, int parent2, double maxMarkerCoverage, String filename, boolean decimalEnglish, String modelType) {
        this.mapFile = mapFile;
        this.genotypesFile = genotypesFile;
        this.qtlFile = qtlFile;
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.maxMarkerCoverage = maxMarkerCoverage;
        this.filename = filename;
        this.decimalEnglish = decimalEnglish;
        if (modelType.equals(UNWEIGHTED)) {
            this.unweighted = true;
        }
    }

    public void doStatGeneration() {
        RB.initialize((String)"auto", (String)"res.text.flapjack");
        TaskDialog.setIsHeadless();
        if (this.decimalEnglish) {
            Locale.setDefault(Locale.UK);
        }
        CreateProject createProject = new CreateProject(this.mapFile, this.genotypesFile, null, this.qtlFile, new FlapjackFile("temp"), null, false);
        try {
            createProject.createProject();
            this.dataSet = createProject.dataSet();
            this.generateMabcStats();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void generateMabcStats() throws Exception {
        GTViewSet viewSet = this.dataSet.getViewSets().get(0);
        boolean[] chromosomes = new boolean[viewSet.chromosomeCount()];
        for (int i = 0; i < chromosomes.length; ++i) {
            chromosomes[i] = true;
        }
        MabcAnalysis stats = new MabcAnalysis(viewSet, chromosomes, this.maxMarkerCoverage, this.parent1, this.parent2, this.unweighted);
        stats.runJob(0);
        MabcTableModel model = new MabcTableModel(viewSet);
        LineDataTable table = new LineDataTable();
        table.setModel(model);
        table.setViewSet(viewSet);
        LineDataTableExporter exporter = new LineDataTableExporter(table, new File(this.filename), 0, false);
        exporter.runJob(0);
    }
}

