/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.BinnedData;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.QTL;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypePanel;
import scri.commons.gui.RB;

public class StatusPanelNB
extends JPanel
implements ActionListener,
ChangeListener {
    private NumberFormat nf = NumberFormat.getInstance();
    private GenotypePanel gPanel;
    private GTView view;
    private JLabel alleleLabel;
    private static JCheckBox checkLink;
    private static JLabel horizontalLabel;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel lineLabel;
    private JLabel markerLabel;
    private static JSlider sliderX;
    private static JSlider sliderY;
    private static JLabel verticalLabel;

    StatusPanelNB(GenotypePanel gPanel) {
        this.gPanel = gPanel;
        this.initComponents();
        RB.setText((JLabel)horizontalLabel, (String)"gui.visualization.StatusPanel.horizontalLabel");
        RB.setText((AbstractButton)checkLink, (String)"gui.visualization.StatusPanel.checkLink");
        this.lineLabel.setForeground(Color.red);
        this.lineLabel.setText(" ");
        this.markerLabel.setForeground(Color.red);
        this.markerLabel.setText(" ");
        this.alleleLabel.setForeground(Color.red);
        this.alleleLabel.setText(" ");
        sliderX.addChangeListener(this);
        sliderX.setBackground((Color)UIManager.get("Panel.background"));
        sliderY.addChangeListener(this);
        sliderY.setBackground((Color)UIManager.get("Panel.background"));
        checkLink.addActionListener(this);
        checkLink.setBackground((Color)UIManager.get("Panel.background"));
        StatusPanelNB.setControlStates();
        this.setForMainUse();
        this.createKeyboardShortcuts();
    }

    private void createKeyboardShortcuts() {
        int shortcut = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        AbstractAction zoomIn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sliderY.setValue(sliderY.getValue() + 1);
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(61, shortcut);
        sliderY.getInputMap(2).put(ks, "zoomInMain");
        sliderY.getActionMap().put("zoomInMain", zoomIn);
        ks = KeyStroke.getKeyStroke(107, shortcut);
        sliderY.getInputMap(2).put(ks, "zoomInNumPad");
        sliderY.getActionMap().put("zoomInNumPad", zoomIn);
        AbstractAction zoomOut = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sliderY.setValue(sliderY.getValue() - 1);
            }
        };
        ks = KeyStroke.getKeyStroke(45, shortcut);
        sliderY.getInputMap(2).put(ks, "zoomOutMain");
        sliderY.getActionMap().put("zoomOutMain", zoomOut);
        ks = KeyStroke.getKeyStroke(109, shortcut);
        sliderY.getInputMap(2).put(ks, "zoomOutNumPad");
        sliderY.getActionMap().put("zoomOutNumPad", zoomOut);
        AbstractAction zoomReset = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sliderY.setValue(7);
            }
        };
        ks = KeyStroke.getKeyStroke(48, shortcut);
        sliderY.getInputMap(2).put(ks, "zoomResetMain");
        sliderY.getActionMap().put("zoomResetMain", zoomReset);
        ks = KeyStroke.getKeyStroke(96, shortcut);
        sliderY.getInputMap(2).put(ks, "zoomResetNumPad");
        sliderY.getActionMap().put("zoomResetNumPad", zoomReset);
    }

    void setForMainUse() {
        RB.setText((JLabel)this.label1, (String)"gui.visualization.StatusPanel.line");
        RB.setText((JLabel)this.label2, (String)"gui.visualization.StatusPanel.marker");
        if (this.dataSetBinned(this.view)) {
            RB.setText((JLabel)this.label3, (String)"gui.visualization.StatusPanel.bin");
        } else {
            RB.setText((JLabel)this.label3, (String)"gui.visualization.StatusPanel.genotype");
        }
    }

    void setForHeatmapUse() {
        RB.setText((JLabel)this.label1, (String)"gui.visualization.StatusPanel.line");
        RB.setText((JLabel)this.label2, (String)"gui.visualization.StatusPanel.trait");
        RB.setText((JLabel)this.label3, (String)"gui.visualization.StatusPanel.value");
    }

    void setForFeatureUse() {
        RB.setText((JLabel)this.label1, (String)"gui.visualization.StatusPanel.featureTrait");
        RB.setText((JLabel)this.label2, (String)"gui.visualization.StatusPanel.featureExperiment");
        RB.setText((JLabel)this.label3, (String)"gui.visualization.StatusPanel.featureData");
    }

    void setForGraphUse() {
        RB.setText((JLabel)this.label1, (String)"gui.visualization.StatusPanel.graph");
        RB.setText((JLabel)this.label2, (String)"gui.visualization.StatusPanel.marker");
        RB.setText((JLabel)this.label3, (String)"gui.visualization.StatusPanel.value");
    }

    public static void setControlStates() {
        if (Prefs.visAdvancedZoom) {
            RB.setText((JLabel)verticalLabel, (String)"gui.visualization.StatusPanel.verticalLabel");
        } else {
            RB.setText((JLabel)verticalLabel, (String)"gui.visualization.StatusPanel.zoomLabel");
            Prefs.visLinkSliders = true;
        }
        horizontalLabel.setVisible(Prefs.visAdvancedZoom);
        sliderX.setVisible(Prefs.visAdvancedZoom);
        checkLink.setVisible(Prefs.visAdvancedZoom);
        checkLink.setSelected(Prefs.visLinkSliders);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Prefs.visLinkSliders = checkLink.isSelected();
        if (Prefs.visLinkSliders) {
            sliderX.setValue(sliderY.getValue());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == sliderX && Prefs.visLinkSliders) {
            sliderY.removeChangeListener(this);
            sliderY.setValue(sliderX.getValue());
            sliderY.addChangeListener(this);
        } else if (e.getSource() == sliderY && Prefs.visLinkSliders) {
            sliderX.removeChangeListener(this);
            sliderX.setValue(sliderY.getValue());
            sliderX.addChangeListener(this);
        }
        this.gPanel.getController().doZoom();
    }

    int getZoomX() {
        return sliderX.getValue();
    }

    int getZoomY() {
        return sliderY.getValue();
    }

    void setZoomY(int value) {
        sliderY.setValue(value);
    }

    void setView(GTView view) {
        this.view = view;
    }

    void setIndices(int lineIndex, int markerIndex) {
        if (lineIndex < 0 || lineIndex >= this.view.lineCount()) {
            this.lineLabel.setText(" ");
        } else {
            String position = lineIndex + 1 + "/" + this.view.lineCount();
            this.lineLabel.setText((this.view.getLineInfo(lineIndex).name() + " (" + position + ")").trim());
        }
        if (markerIndex < 0 || markerIndex >= this.view.markerCount()) {
            this.markerLabel.setText(" ");
        } else {
            Marker m = this.view.getMarker(markerIndex);
            if (!m.dummyMarker()) {
                this.markerLabel.setText(m.getName() + " (" + this.nf.format(m.getRealPosition()) + ")");
            } else {
                this.markerLabel.setText(" ");
            }
        }
        if (lineIndex < 0 || lineIndex >= this.view.lineCount() || markerIndex < 0 || markerIndex >= this.view.markerCount()) {
            this.alleleLabel.setText(" ");
        } else {
            int stateCode = this.view.getState(lineIndex, markerIndex);
            if (stateCode == 0) {
                this.alleleLabel.setText(" ");
            } else {
                StateTable st = this.view.getViewSet().getDataSet().getStateTable();
                AlleleState state = st.getAlleleState(stateCode);
                BinnedData binData = this.view.getViewSet().getDataSet().getBinnedData();
                this.alleleLabel.setText(state.toString() + " " + binData.getBinForState(state.toString()));
            }
        }
    }

    void setHeatmapValues(String line, String trait, String value) {
        this.lineLabel.setText(line);
        this.markerLabel.setText(trait);
        this.alleleLabel.setText(value);
    }

    void setGraphDetails(String graph, String marker, String value) {
        this.lineLabel.setText(graph);
        this.markerLabel.setText(marker);
        this.alleleLabel.setText(value);
    }

    void setQTLDetails(QTL qtl) {
        if (qtl != null) {
            this.lineLabel.setText(qtl.getTrait());
            this.markerLabel.setText(qtl.getExperiment());
            String data = "";
            for (int i = 0; i < qtl.getVNames().length; ++i) {
                if (i > 0) {
                    data = data + ", ";
                }
                try {
                    float value = this.nf.parse(qtl.getValues()[i]).floatValue();
                    data = data + qtl.getVNames()[i] + " (" + this.nf.format(value) + ")";
                    continue;
                }
                catch (Exception e) {
                    data = data + qtl.getVNames()[i] + " (" + qtl.getValues()[i] + ")";
                }
            }
            if (data.length() > 0) {
                this.alleleLabel.setText(data);
            } else {
                this.alleleLabel.setText(" ");
            }
        } else {
            this.lineLabel.setText(" ");
            this.markerLabel.setText(" ");
            this.alleleLabel.setText(" ");
        }
    }

    void setResultsValues(String line, String result, String value) {
        RB.setText((JLabel)this.label1, (String)"gui.visualization.StatusPanel.line");
        this.label2.setText(result);
        this.label3.setText(" ");
        this.lineLabel.setText(line);
        this.markerLabel.setText(value);
        this.alleleLabel.setText(" ");
        if (result == null || result.isEmpty()) {
            this.label2.setText(" ");
        }
        if (value == null || value.isEmpty()) {
            this.markerLabel.setText(" ");
        }
    }

    private boolean dataSetBinned(GTView view) {
        return view != null && (view.getViewSet().getDataSet().getBinnedData().containsBins() || view.getViewSet().getColorScheme() == 9);
    }

    private void initComponents() {
        this.label1 = new JLabel();
        this.lineLabel = new JLabel();
        this.label2 = new JLabel();
        this.markerLabel = new JLabel();
        this.label3 = new JLabel();
        this.alleleLabel = new JLabel();
        horizontalLabel = new JLabel();
        sliderX = new JSlider();
        checkLink = new JCheckBox();
        verticalLabel = new JLabel();
        sliderY = new JSlider();
        this.label1.setText("Line:");
        this.lineLabel.setText("<>");
        this.label2.setText("Marker:");
        this.markerLabel.setText("<>");
        this.label3.setText("Genotype:");
        this.alleleLabel.setText("<>");
        horizontalLabel.setLabelFor(sliderX);
        horizontalLabel.setText("Horizontal zoom:");
        sliderX.setMaximum(25);
        sliderX.setMinimum(1);
        sliderX.setPaintTicks(true);
        sliderX.setSnapToTicks(true);
        sliderX.setValue(7);
        checkLink.setText("Link");
        verticalLabel.setLabelFor(sliderY);
        verticalLabel.setText("Vertical zoom:");
        sliderY.setMaximum(25);
        sliderY.setMinimum(1);
        sliderY.setPaintTicks(true);
        sliderY.setSnapToTicks(true);
        sliderY.setValue(7);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label3).addComponent(this.label1).addComponent(this.label2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.alleleLabel).addComponent(this.markerLabel).addComponent(this.lineLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 99, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(horizontalLabel).addComponent(sliderX, -2, 155, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(checkLink).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(sliderY, -2, 155, -2).addComponent(verticalLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.label1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label3)).addGroup(layout.createSequentialGroup().addComponent(this.lineLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.markerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alleleLabel))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(horizontalLabel).addComponent(verticalLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(sliderX, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(sliderY, -2, -1, -2).addComponent(checkLink))))).addContainerGap()));
    }
}

