/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.IOverlayRenderer;

public class SplitterOverlay
implements IOverlayRenderer {
    private GenotypePanel gPanel;

    public SplitterOverlay(GenotypePanel gPanel) {
        this.gPanel = gPanel;
    }

    @Override
    public void render(Graphics2D g) {
        GenotypeCanvas canvas = this.gPanel.canvas;
        GTView view = this.gPanel.getView();
        if (view == canvas.view && view.getSplitterIndex() != -1) {
            int y1 = view.getSplitterIndex() * canvas.boxH;
            g.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{canvas.boxW / 2}, canvas.boxW / 4));
            g.setPaint(new Color(100, 100, 100));
            g.drawLine(0, y1 + canvas.boxH / 2, canvas.canvasW - 1, y1 + canvas.boxH / 2);
        }
    }
}

