/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.importer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.dialog.importer.BrapiImportDialog;
import jhi.flapjack.gui.dialog.importer.IBrapiWizard;
import jhi.flapjack.io.brapi.BrapiClient;
import jhi.flapjack.io.brapi.XmlBrapiProvider;
import jhi.flapjack.io.brapi.XmlCategory;
import jhi.flapjack.io.brapi.XmlResource;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;
import scri.commons.gui.matisse.HyperLinkLabel;

class BrapiDataPanelNB
extends JPanel
implements IBrapiWizard {
    private XmlBrapiProvider data;
    private BrapiClient client;
    private BrapiImportDialog dialog;
    private DefaultComboBoxModel<XmlCategory> catModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel<XmlResource> resModel = new DefaultComboBoxModel();
    private JComboBox<XmlCategory> catCombo;
    private JLabel catLogo;
    private JTextArea catText;
    private HyperLinkLabel hyperLinkLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JComboBox<XmlResource> resCombo;
    private JLabel resLogo;
    private JTextArea resText;

    public BrapiDataPanelNB(BrapiClient client, BrapiImportDialog dialog) {
        this.client = client;
        this.dialog = dialog;
        this.initComponents();
        this.catCombo.setModel(this.catModel);
        this.catCombo.addItemListener(e -> this.displayCategory());
        this.resCombo.setModel(this.resModel);
        this.resCombo.addItemListener(e -> this.displayResource());
    }

    @Override
    public void onShow() {
        this.dialog.enableBack(false);
        if (this.catModel.getSize() == 0) {
            this.refreshData();
        } else {
            this.dialog.enableNext(true);
        }
    }

    @Override
    public void onNext() {
        if (this.validateCalls()) {
            if (this.client.hasToken()) {
                this.dialog.setScreen(this.dialog.getPassPanel());
            } else {
                this.dialog.setScreen(this.dialog.getStudiesPanel());
            }
        }
        this.dialog.getBNext().requestFocusInWindow();
    }

    @Override
    public void onBack() {
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public String getCardName() {
        return "data";
    }

    void refreshData() {
        ProgressDialog pd = new ProgressDialog((ITrackableJob)new DataDownloader(), RB.getString((String)"gui.dialog.importer.BrapiDataPanelNB.title"), RB.getString((String)"gui.dialog.importer.BrapiDataPanelNB.message"), (Frame)Flapjack.winMain);
        if (pd.failed("gui.error")) {
            return;
        }
        this.catModel.removeAllElements();
        for (XmlCategory cat : this.data.getCategories()) {
            this.catModel.addElement(cat);
        }
    }

    private void displayCategory() {
        int index = this.catCombo.getSelectedIndex();
        if (index >= 0) {
            XmlCategory cat = this.catModel.getElementAt(index);
            this.catText.setText(cat.getDescription());
            this.catText.setCaretPosition(0);
            this.resModel.removeAllElements();
            for (XmlResource resource : cat.getResources()) {
                this.resModel.addElement(resource);
            }
            this.setIcon(cat.getImage(), this.catLogo);
        } else {
            this.catText.setText(null);
            this.setIcon(null, this.catLogo);
        }
    }

    private void displayResource() {
        int index = this.resCombo.getSelectedIndex();
        if (index >= 0) {
            XmlResource res = this.resModel.getElementAt(index);
            this.resText.setText(res.getDescription());
            this.resText.setCaretPosition(0);
            this.setIcon(res.getImage(), this.resLogo);
            this.client.setResource(res);
            this.dialog.enableNext(true);
        } else {
            this.resText.setText(null);
            this.setIcon(null, this.resLogo);
            this.dialog.enableNext(false);
        }
    }

    private void setIcon(ImageIcon icon, JLabel label) {
        if (icon == null) {
            label.setIcon(null);
        } else {
            int w = icon.getIconWidth();
            int h = icon.getIconHeight();
            double scalex = (double)label.getSize().width / (double)w;
            double scaley = (double)label.getSize().height / (double)h;
            double scale = Math.min(scalex, scaley);
            Image i = icon.getImage().getScaledInstance((int)((double)w * scale), (int)((double)h * scale), 4);
            label.setIcon(new ImageIcon(i));
        }
    }

    boolean validateCalls() {
        ProgressDialog pd = new ProgressDialog((ITrackableJob)new CallsDownloader(), RB.getString((String)"gui.dialog.importer.BrapiDataPanelNB.title2"), RB.getString((String)"gui.dialog.importer.BrapiDataPanelNB.message2"), (Frame)Flapjack.winMain);
        return !pd.failed("gui.error");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.hyperLinkLabel1 = new HyperLinkLabel();
        this.catCombo = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.catText = new JTextArea();
        this.jLabel3 = new JLabel();
        this.resCombo = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.resText = new JTextArea();
        this.jPanel2 = new JPanel();
        this.catLogo = new JLabel();
        this.jPanel3 = new JPanel();
        this.resLogo = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Remote data source:"));
        this.jLabel2.setLabelFor(this.catCombo);
        this.jLabel2.setText("Category:");
        this.hyperLinkLabel1.setText("Edit data source providers");
        this.jScrollPane1.setHorizontalScrollBar(null);
        this.catText.setEditable(false);
        this.catText.setColumns(20);
        this.catText.setLineWrap(true);
        this.catText.setRows(5);
        this.catText.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.catText);
        this.jLabel3.setLabelFor(this.resCombo);
        this.jLabel3.setText("Resource to connect to:");
        this.resCombo.setActionCommand("");
        this.jScrollPane2.setHorizontalScrollBar(null);
        this.resText.setEditable(false);
        this.resText.setColumns(20);
        this.resText.setLineWrap(true);
        this.resText.setRows(5);
        this.resText.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.resText);
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setOpaque(false);
        this.catLogo.setHorizontalAlignment(0);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.catLogo, -1, 106, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.catLogo, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setOpaque(false);
        this.resLogo.setHorizontalAlignment(0);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.resLogo, -1, 110, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.resLogo, -1, -1, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 307, Short.MAX_VALUE).addComponent((Component)this.hyperLinkLabel1, -2, -1, -2)).addComponent(this.resCombo, 0, -1, Short.MAX_VALUE).addComponent(this.catCombo, 0, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.hyperLinkLabel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane2).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class CallsDownloader
    extends SimpleJob {
        private CallsDownloader() {
        }

        public void runJob(int jobID) throws Exception {
            BrapiDataPanelNB.this.client.initService();
            BrapiDataPanelNB.this.client.getCalls();
        }
    }

    private class DataDownloader
    extends SimpleJob {
        private DataDownloader() {
        }

        public void runJob(int jobID) throws Exception {
            BrapiDataPanelNB.this.data = BrapiDataPanelNB.this.client.getBrapiProviders();
        }
    }
}

