/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import java.awt.Frame;
import java.io.File;
import java.net.URLEncoder;
import javax.swing.filechooser.FileNameExtensionFilter;
import jhi.flapjack.analysis.DataSummary;
import jhi.flapjack.data.DBAssociation;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Marker;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.NavPanel;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.WinMain;
import jhi.flapjack.gui.dialog.DatabaseSettingsDialog;
import jhi.flapjack.gui.dialog.FilterQTLsDialog;
import jhi.flapjack.gui.dialog.RenameDialog;
import jhi.flapjack.gui.dialog.SelectGraphDialog;
import jhi.flapjack.gui.dialog.SelectTraitsDialog;
import jhi.flapjack.gui.dialog.analysis.DataSummaryDialog;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.io.QTLExporter;
import jhi.flapjack.io.TraitExporter;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class MenuData {
    private WinMain winMain;
    private NavPanel navPanel;
    private GenotypePanel gPanel;

    void setComponents(WinMain winMain, NavPanel navPanel) {
        this.winMain = winMain;
        this.navPanel = navPanel;
        this.gPanel = navPanel.getGenotypePanel();
    }

    public void dataFilterQTLs() {
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        this.winMain.filterQTLDialog = new FilterQTLsDialog(this.gPanel, dataSet);
    }

    public void dataSelectGraph() {
        this.winMain.selectGraphDialog = new SelectGraphDialog(this.gPanel);
    }

    void dataFind() {
        this.winMain.getFindDialog().setVisible(true);
    }

    void dataStatistics() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        DataSummary statistics = new DataSummary(viewSet);
        ProgressDialog pd = new ProgressDialog((ITrackableJob)statistics, RB.format((String)"gui.MenuData.statistics.title", (Object[])new Object[0]), RB.format((String)"gui.MenuData.statistics.label", (Object[])new Object[0]), (Frame)Flapjack.winMain);
        if (pd.getResult() == 0) {
            new DataSummaryDialog(viewSet, statistics.getResults(), statistics.getAlleleCount());
        }
    }

    void dataDBLineName() {
        DBAssociation db = this.gPanel.getViewSet().getDataSet().getDbAssociation();
        GTView view = this.gPanel.getView();
        if (view.mouseOverLine >= 0 && view.mouseOverLine < view.lineCount()) {
            Line line = view.getLine(view.mouseOverLine);
            try {
                String lineURL = URLEncoder.encode(line.getName(), "UTF-8");
                String url = db.getLineSearch().replace("$LINE", lineURL);
                url = url.indexOf("?") == -1 ? url + "?application=flapjack" : url + "&application=flapjack";
                System.out.println("URL String: " + url.toString());
                FlapjackUtils.visitURL(url.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void dataDBMarkerName() {
        DBAssociation db = this.gPanel.getViewSet().getDataSet().getDbAssociation();
        GTView view = this.gPanel.getView();
        if (view.mouseOverMarker >= 0 && view.mouseOverMarker < view.markerCount()) {
            Marker marker = view.getMarker(view.mouseOverMarker);
            try {
                String markerURL = URLEncoder.encode(marker.getName(), "UTF-8");
                String url = db.getMarkerSearch().replace("$MARKER", markerURL);
                url = url.indexOf("?") == -1 ? url + "?application=flapjack" : url + "&application=flapjack";
                FlapjackUtils.visitURL(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void dataDBSettings() {
        DataSet dataSet = this.gPanel.getViewSet().getDataSet();
        DatabaseSettingsDialog dialog = new DatabaseSettingsDialog(dataSet);
    }

    void dataRenameDataSet() {
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        RenameDialog dialog = new RenameDialog(dataSet.getName());
        if (dialog.isOK()) {
            dataSet.setName(dialog.getNewName());
            this.navPanel.updateNodeFor(dataSet);
            Actions.projectModified();
        }
    }

    void dataDeleteDataSet() {
        String msg = RB.getString((String)"gui.WinMain.deleteDataSet");
        String[] options = new String[]{RB.getString((String)"gui.WinMain.deleteDataSetButton"), RB.getString((String)"gui.text.cancel")};
        if (TaskDialog.show((String)msg, (int)3, (int)1, (String[])options) == 0) {
            DataSet dataSet = this.navPanel.getDataSetForSelection();
            this.winMain.getProject().removeDataSet(dataSet);
            this.navPanel.removeDataSetNode(dataSet);
            Actions.projectModified();
        }
    }

    public void dataSelectTraits() {
        SelectTraitsDialog dialog = new SelectTraitsDialog(this.gPanel.getViewSet());
        this.gPanel.setViewSet(this.gPanel.getViewSet());
    }

    public void dataExportQTLs() {
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        String name = RB.format((String)"gui.MenuData.exportQTLs.filename", (Object[])new Object[]{dataSet.getName()});
        File saveAs = new File(Prefs.guiCurrentDir, name);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(RB.getString((String)"other.Filters.txt"), "txt");
        String filename = FlapjackUtils.getSaveFilename(RB.getString((String)"gui.MenuData.exportQTLs.saveDialog"), saveAs, filter);
        if (filename == null) {
            return;
        }
        QTLExporter exporter = new QTLExporter(dataSet, new File(filename));
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)exporter, RB.format((String)"gui.dialog.ExportDataDialog.exportTitle", (Object[])new Object[0]), RB.format((String)"gui.dialog.ExportDataDialog.exportLabel", (Object[])new Object[0]), (Frame)this.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        TaskDialog.info((String)RB.format((String)"gui.dialog.ExportDataDialog.exportSuccess", (Object[])new Object[]{filename}), (String)RB.getString((String)"gui.text.close"));
    }

    public void dataExportTraits() {
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        String name = RB.format((String)"gui.MenuData.exportTraits.filename", (Object[])new Object[]{dataSet.getName()});
        File saveAs = new File(Prefs.guiCurrentDir, name);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(RB.getString((String)"other.Filters.txt"), "txt");
        String filename = FlapjackUtils.getSaveFilename(RB.getString((String)"gui.MenuData.exportTraits.saveDialog"), saveAs, filter);
        if (filename == null) {
            return;
        }
        TraitExporter exporter = new TraitExporter(dataSet, new File(filename));
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)exporter, RB.format((String)"gui.dialog.ExportDataDialog.exportTitle", (Object[])new Object[0]), RB.format((String)"gui.dialog.ExportDataDialog.exportLabel", (Object[])new Object[0]), (Frame)this.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        TaskDialog.info((String)RB.format((String)"gui.dialog.ExportDataDialog.exportSuccess", (Object[])new Object[]{filename}), (String)RB.getString((String)"gui.text.close"));
    }
}

