/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.MarkerInfo;
import scri.commons.gui.SimpleJob;

public class FilterMissingMarkersByLine
extends SimpleJob {
    private GTViewSet viewSet;
    private boolean[] selectedChromosomes;
    private LineInfo line;
    private int count;

    public FilterMissingMarkersByLine(GTViewSet viewSet, boolean[] selectedChromosomes, LineInfo line) {
        this.viewSet = viewSet;
        this.selectedChromosomes = selectedChromosomes;
        this.line = line;
    }

    public int getCount() {
        return this.count;
    }

    public void runJob(int index) throws Exception {
        AnalysisSet as = new AnalysisSet(this.viewSet).withViews(this.selectedChromosomes).withAllLines().withSelectedMarkers();
        for (int i = 0; i < as.viewCount(); ++i) {
            this.maximum += as.markerCount(i);
        }
        int lineIndex = as.getLines().indexOf(this.line);
        for (int view = 0; view < as.viewCount(); ++view) {
            boolean isSpecialChromosome = as.getGTView(view).getChromosomeMap().isSpecialChromosome();
            for (int marker = as.markerCount(view) - 1; marker >= 0 && this.okToRun; --marker) {
                if (as.getState(view, lineIndex, marker) == 0) {
                    MarkerInfo mi = as.getMarker(view, marker);
                    as.getGTView(view).hideMarker(mi);
                    if (!isSpecialChromosome) {
                        ++this.count;
                    }
                }
                ++this.progress;
            }
        }
    }
}

