/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends FilterInputStream {
    private long nread = 0L;
    private long size = 0L;

    public ProgressInputStream(InputStream in) {
        super(in);
        try {
            this.size = in.available();
        }
        catch (IOException ioe) {
            this.size = 0L;
        }
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public long getBytesRead() {
        return this.nread;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            ++this.nread;
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.nread += (long)nr;
        }
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.nread += (long)nr;
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.nread += nr;
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - (long)this.in.available();
    }
}

