/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.brapi;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jhi.brapi.api.genomemaps.BrapiLinkageGroup;
import jhi.brapi.api.genomemaps.BrapiMapMetaData;
import jhi.brapi.api.genomemaps.BrapiMarkerPosition;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Marker;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.io.IMapImporter;
import jhi.flapjack.io.MarkerIndex;
import jhi.flapjack.io.brapi.BrapiClient;

public class BrapiMapImporter
implements IMapImporter {
    private BrapiClient client;
    private DataSet dataSet;
    private HashMap<String, MarkerIndex> markers = new HashMap();
    private HashMap<String, MarkerIndex> markersByName = new HashMap();
    private long markerCount = 0L;
    private LinkedList<String> duplicates = new LinkedList();
    private boolean isOK = true;

    public BrapiMapImporter(BrapiClient client, DataSet dataSet) {
        this.client = client;
        this.dataSet = dataSet;
    }

    @Override
    public HashMap<String, MarkerIndex> getMarkersHashMap() {
        return this.markers;
    }

    public HashMap<String, MarkerIndex> getMarkersByName() {
        return this.markersByName;
    }

    @Override
    public void cancelImport() {
        this.isOK = false;
    }

    @Override
    public void importMap() throws Exception {
        NumberFormat nf = NumberFormat.getInstance();
        List<BrapiMarkerPosition> list = this.client.getMapMarkerData();
        HashMap<String, String> namesToIDs = new HashMap<String, String>();
        for (BrapiMarkerPosition bm : list) {
            namesToIDs.put(bm.getMarkerName(), bm.getMarkerDbId());
            double position = nf.parse(bm.getLocation()).doubleValue();
            String chromosome = bm.getLinkageGroup();
            Marker marker = new Marker(bm.getMarkerName(), position);
            MarkerIndex index = this.markers.get(bm.getMarkerDbId());
            if (index != null) {
                if (!Prefs.warnDuplicateMarkers) continue;
                this.duplicates.add(marker.getName() + "\t" + chromosome + "\t" + this.dataSet.getMapByIndex(index.mapIndex).getName());
                continue;
            }
            ChromosomeMap.Wrapper w = this.dataSet.getMapByName(chromosome, true);
            w.map.addMarker(marker);
            MarkerIndex mi = new MarkerIndex(w.index, 0);
            this.markers.put(bm.getMarkerDbId(), mi);
            this.markersByName.put(bm.getMarkerName(), mi);
            ++this.markerCount;
        }
        if (this.isOK && this.client.hasMapsMapDbId()) {
            BrapiMapMetaData md = this.client.getMapMetaData();
            for (BrapiLinkageGroup group : md.getLinkageGroups()) {
                ChromosomeMap.Wrapper wrapper = this.dataSet.getMapByName(group.getLinkageGroupId(), false);
                wrapper.map.setLength(group.getMaxPosition());
            }
        }
        if (this.isOK) {
            this.dataSet.orderMarkersWithinMaps();
        }
        Collections.sort(this.dataSet.getChromosomeMaps());
        System.out.println("markers.size() = " + this.markers.size());
        int mapIndex = 0;
        for (ChromosomeMap map : this.dataSet.getChromosomeMaps()) {
            int mkrIndex = 0;
            for (Marker marker : map) {
                MarkerIndex mi = this.markers.get(namesToIDs.get(marker.getName()));
                mi.mkrIndex = mkrIndex++;
                mi.mapIndex = (short)mapIndex;
            }
            mapIndex = (short)(mapIndex + 1);
        }
    }

    @Override
    public LinkedList<String> getDuplicates() {
        return this.duplicates;
    }

    @Override
    public long getBytesRead() {
        return 0L;
    }

    @Override
    public long getMarkerCount() {
        return this.markerCount;
    }
}

