/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import jhi.flapjack.data.GraphData;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.MarkerInfo;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.WinMainMenuBar;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.GraphCanvas;
import scri.commons.gui.RB;

class GraphCanvasML
extends MouseInputAdapter
implements ActionListener {
    private NumberFormat nf = NumberFormat.getInstance();
    private GenotypePanel gPanel;
    private GraphCanvas graphCanvas;
    private GenotypeCanvas canvas;
    private static JMenuItem mDataSelectGraph;
    private static JCheckBoxMenuItem mHistogram;
    private static JCheckBoxMenuItem mLineGraph;

    GraphCanvasML(GenotypePanel gPanel, GraphCanvas graphCanvas) {
        this.gPanel = gPanel;
        this.graphCanvas = graphCanvas;
        this.canvas = gPanel.canvas;
        graphCanvas.addMouseListener(this);
        graphCanvas.addMouseMotionListener(this);
        mDataSelectGraph = WinMainMenuBar.getItem(Actions.dataSelectGraph, "gui.Actions.dataSelectGraph", 0, 0);
        mHistogram = new JCheckBoxMenuItem(RB.getString((String)"gui.GraphCanvasML.mHistogram"));
        mHistogram.addActionListener(this);
        mLineGraph = new JCheckBoxMenuItem(RB.getString((String)"gui.GraphCanvasML.mLineGraph"));
        mLineGraph.addActionListener(this);
        ButtonGroup grp = new ButtonGroup();
        grp.add(mHistogram);
        grp.add(mLineGraph);
        if (Prefs.guiGraphStyle == 0) {
            mHistogram.setSelected(true);
        } else if (Prefs.guiGraphStyle == 1) {
            mLineGraph.setSelected(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.displayMenu(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.displayMenu(e);
        }
    }

    private void displayMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(mDataSelectGraph);
        menu.addSeparator();
        menu.add(mHistogram);
        menu.add(mLineGraph);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == mHistogram) {
            Prefs.guiGraphStyle = 0;
            this.gPanel.refreshView();
        } else if (e.getSource() == mLineGraph) {
            Prefs.guiGraphStyle = 1;
            this.gPanel.refreshView();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.gPanel.statusPanel.setForGraphUse();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.gPanel.statusPanel.setGraphDetails(null, null, null);
        this.gPanel.statusPanel.setForMainUse();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        GraphData data = this.graphCanvas.graphData;
        if (data == null) {
            return;
        }
        int x = e.getPoint().x + this.canvas.pX1 - this.graphCanvas.xOffset;
        if (x >= this.canvas.pX1 && x <= this.canvas.pX2) {
            int mIndex = this.canvas.getMarker(new Point(x, 0));
            MarkerInfo mi = this.canvas.view.getMarkerInfo(mIndex);
            float value = data.getRealValueAt(mi.getIndex());
            String graph = data.getName();
            if (mi.dummyMarker()) {
                this.gPanel.statusPanel.setGraphDetails(graph, " ", " ");
                return;
            }
            Marker m = mi.getMarker();
            String mStr = m.getName() + "  (" + this.nf.format(m.getRealPosition()) + ")";
            String vStr = this.nf.format(value);
            if (data.getHasThreshold()) {
                vStr = vStr + "  (" + this.nf.format(data.getThreshold()) + ")";
            }
            this.gPanel.statusPanel.setGraphDetails(graph, mStr, vStr);
            this.gPanel.mapCanvas.setMarkerIndex(mIndex);
            this.gPanel.canvas.setHighlightedIndices(-1, mIndex);
        } else {
            this.gPanel.statusPanel.setGraphDetails(null, null, null);
        }
    }
}

