/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.StateTable;
import scri.commons.gui.SimpleJob;

public class CalculateMarkerFrequencies
extends SimpleJob {
    public static final int ALLELE_METHOD = 0;
    public static final int GENOTYPE_METHOD = 1;
    private int method;
    private DataSet dataSet;
    private StateTable stateTable;
    private String[] alleles;
    private ArrayList<Mapper> mapping;

    public CalculateMarkerFrequencies(DataSet dataSet, int method) {
        this.dataSet = dataSet;
        this.method = method;
        this.stateTable = dataSet.getStateTable();
        for (int ch = 0; ch < dataSet.countChromosomeMaps(); ++ch) {
            this.maximum += dataSet.getMapByIndex(ch).countLoci();
        }
    }

    public void runJob(int index) throws Exception {
        if (this.method == 0) {
            this.prepareAlleleMapping();
        }
        for (int ch = 0; ch < this.dataSet.countChromosomeMaps(); ++ch) {
            ChromosomeMap map = this.dataSet.getMapByIndex(ch);
            for (int marker = 0; marker < map.countLoci() && this.okToRun; ++marker) {
                float[] freqs;
                ++this.progress;
                if (map.getMarkerByIndex(marker).frequencies() != null) continue;
                if (this.method == 0) {
                    freqs = this.getAlleleFrequencies(ch, marker);
                    map.getMarkerByIndex(marker).setFrequencies(freqs);
                    continue;
                }
                freqs = this.getGenotypeFrequencies(ch, marker);
                map.getMarkerByIndex(marker).setFrequencies(freqs);
            }
        }
    }

    private void prepareAlleleMapping() {
        HashMap<String, String> names = this.stateTable.uniqueAlleles();
        this.alleles = names.keySet().toArray(new String[0]);
        this.mapping = new ArrayList();
        for (int i = 0; i < this.stateTable.size(); ++i) {
            AlleleState state = this.stateTable.getAlleleState(i);
            Mapper m = new Mapper(state.getStates().length);
            this.mapping.add(m);
            for (int j = 0; j < state.getStates().length; ++j) {
                for (int k = 0; k < this.alleles.length; ++k) {
                    if (!this.alleles[k].equals(state.getStates()[j])) continue;
                    m.indexes[j] = k;
                }
            }
        }
        Marker.setAlleles(this.alleles);
    }

    float[] getGenotypeFrequencies(int chromosome, int marker) {
        float[] freqs = new float[this.stateTable.size()];
        float lineCount = 0.0f;
        for (Line line : this.dataSet.getLines()) {
            int state;
            int n = state = line.getState(chromosome, marker);
            freqs[n] = freqs[n] + 1.0f;
            lineCount += 1.0f;
        }
        for (int i = 0; i < freqs.length; ++i) {
            freqs[i] = freqs[i] / lineCount;
        }
        return freqs;
    }

    float[] getAlleleFrequencies(int chromosome, int marker) {
        float[] freqs = new float[this.alleles.length];
        float lineCount = 0.0f;
        for (Line line : this.dataSet.getLines()) {
            int state = line.getState(chromosome, marker);
            if (state == 0) continue;
            this.mapping.get(state).increment(freqs);
            lineCount += 1.0f;
        }
        for (int i = 0; i < freqs.length; ++i) {
            freqs[i] = freqs[i] / lineCount;
        }
        return freqs;
    }

    static class Mapper {
        int[] indexes;
        float value;

        Mapper(int size) {
            this.indexes = new int[size];
            this.value = size == 1 ? 1.0f : 0.5f;
        }

        private void increment(float[] freqs) {
            int[] nArray = this.indexes;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int fIndex;
                int n2 = fIndex = nArray[i];
                freqs[n2] = freqs[n2] + this.value;
            }
        }
    }
}

