/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.undo;

import java.util.ArrayList;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.IUndoState;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.table.SortColumn;

public class MovedLinesState
implements IUndoState {
    private GTViewSet viewSet;
    private String menuStr;
    private ArrayList<LineInfo> undoLines;
    private Line undoComparisonLine;
    private int undoComparisonLineIndex;
    private ArrayList<LineInfo> redoLines;
    private Line redoComparisonLine;
    private int redoComparisonLineIndex;
    private ArrayList<SortColumn> undoColumns;
    private ArrayList<SortColumn> redoColumns;

    public MovedLinesState(GTViewSet viewSet, String menuStr) {
        this.viewSet = viewSet;
        this.menuStr = menuStr;
    }

    @Override
    public GTView getView() {
        return null;
    }

    @Override
    public String getMenuString() {
        return this.menuStr;
    }

    @Override
    public void createUndoState() {
        this.undoLines = this.viewSet.copyLines(LineInfo.VISIBLE);
        this.undoComparisonLine = this.viewSet.getComparisonLine();
        this.undoComparisonLineIndex = this.viewSet.getComparisonLineIndex();
        this.undoColumns = this.viewSet.tableHandler().getSortKeys();
    }

    @Override
    public void applyUndoState() {
        this.viewSet.setLinesFromCopies(this.undoLines, null, null);
        this.viewSet.setComparisonLine(this.undoComparisonLine);
        this.viewSet.setComparisonLineIndex(this.undoComparisonLineIndex);
        this.viewSet.tableHandler().undoRedoApplySort(this.undoColumns);
    }

    @Override
    public void createRedoState() {
        this.redoLines = this.viewSet.copyLines(LineInfo.VISIBLE);
        this.redoComparisonLine = this.viewSet.getComparisonLine();
        this.redoComparisonLineIndex = this.viewSet.getComparisonLineIndex();
        this.redoColumns = this.viewSet.tableHandler().getSortKeys();
    }

    @Override
    public void applyRedoState() {
        this.viewSet.setLinesFromCopies(this.redoLines, null, null);
        this.viewSet.setComparisonLine(this.redoComparisonLine);
        this.viewSet.setComparisonLineIndex(this.redoComparisonLineIndex);
        this.viewSet.tableHandler().undoRedoApplySort(this.redoColumns);
    }
}

