/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.analysis;

import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Trait;
import scri.commons.gui.RB;

class SortLinesByTraitTableModel
extends AbstractTableModel {
    private DataSet dataSet;
    private ArrayList<Trait> traits;
    private ArrayList<TableRow> rows;
    private String[] columnNames;

    SortLinesByTraitTableModel(DataSet dataSet) {
        this.dataSet = dataSet;
        this.traits = dataSet.getTraits();
        this.columnNames = new String[]{RB.getString((String)"gui.dialog.analysis.NBSortLinesByTraitPanel.col1"), RB.getString((String)"gui.dialog.analysis.NBSortLinesByTraitPanel.col2")};
        this.rows = new ArrayList();
        if (this.traits.size() > 0) {
            this.rows.add(new TableRow());
        }
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            int traitIndex = this.rows.get((int)row).traitIndex;
            return this.traits.get(traitIndex).getName();
        }
        return this.rows.get((int)row).isAscending;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return String.class;
        }
        return Boolean.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    JComboBox getTraitComboBox() {
        JComboBox<TraitEntry> combo = new JComboBox<TraitEntry>();
        for (int i = 0; i < this.traits.size(); ++i) {
            combo.addItem(new TraitEntry(i, this.traits.get(i).getName()));
        }
        return combo;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TableRow tRow = this.rows.get(row);
        if (col == 0) {
            tRow.traitIndex = ((TraitEntry)value).index;
        } else {
            tRow.isAscending = (Boolean)value;
        }
        this.fireTableCellUpdated(row, col);
    }

    void addRow() {
        this.rows.add(new TableRow());
        this.fireTableDataChanged();
    }

    void deleteRow(int row) {
        this.rows.remove(row);
        this.fireTableDataChanged();
    }

    int[] getTraitIndices() {
        int[] selected = new int[this.rows.size()];
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = this.rows.get((int)i).traitIndex;
        }
        return selected;
    }

    public boolean[] getAscendingIndices() {
        boolean[] selected = new boolean[this.rows.size()];
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = this.rows.get((int)i).isAscending;
        }
        return selected;
    }

    private static class TableRow {
        int traitIndex;
        boolean isAscending;

        private TableRow() {
        }
    }

    private static class TraitEntry {
        int index;
        String traitName;

        TraitEntry(int index, String traitName) {
            this.index = index;
            this.traitName = traitName;
        }

        public String toString() {
            return this.traitName;
        }
    }
}

