/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dendrogram;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import jhi.flapjack.data.results.Dendrogram;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dendrogram.DendrogramCanvas;
import scri.commons.gui.Icons;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class DendrogramPanelNB
extends JPanel
implements ActionListener {
    private Dendrogram dendrogram;
    private DendrogramCanvas dCanvas;
    private JButton bExportPDF;
    JButton bExportPNG;
    JScrollPane sp;

    public DendrogramPanelNB(Dendrogram dendrogram, DendrogramCanvas dCanvas) {
        this.dendrogram = dendrogram;
        this.dCanvas = dCanvas;
        this.initComponents();
        this.sp.setViewportView(dCanvas);
        this.sp.setWheelScrollingEnabled(false);
        this.bExportPNG.setText(RB.getString((String)"gui.dendrogram.DendrogramPanelNB.bExportPNG"));
        this.bExportPNG.setIcon(Icons.getIcon((String)"MIMEPNG"));
        this.bExportPNG.addActionListener(this);
        this.bExportPDF.setText(RB.getString((String)"gui.dendrogram.DendrogramPanelNB.bExportPDF"));
        this.bExportPDF.setIcon(Icons.getIcon((String)"MIMEPDF"));
        this.bExportPDF.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bExportPNG) {
            this.exportAsPNG();
        } else if (e.getSource() == this.bExportPDF) {
            this.exportAsPDF();
        }
    }

    private void exportAsPNG() {
        String name = this.dendrogram.getTitle() + ".png";
        File saveAs = new File(Prefs.guiCurrentDir, name);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(RB.getString((String)"other.Filters.png"), "png");
        String filename = FlapjackUtils.getSaveFilename(RB.getString((String)"gui.dendrogram.DendrogramPanelNB.saveAs"), saveAs, filter);
        if (filename != null) {
            try {
                ImageIO.write((RenderedImage)this.dCanvas.image, "PNG", saveAs);
                TaskDialog.info((String)RB.format((String)"gui.dendrogram.DendrogramPanelNB.saveAsSuccess", (Object[])new Object[]{saveAs.getPath()}), (String)RB.getString((String)"gui.text.close"));
            }
            catch (Exception e) {
                TaskDialog.error((String)RB.format((String)"gui.dendrogram.DendrogramPanelNB.saveAsFail", (Object[])new Object[]{e.getMessage()}), (String)RB.getString((String)"gui.text.close"));
            }
        }
    }

    private void exportAsPDF() {
        String name = this.dendrogram.getTitle() + ".pdf";
        File saveAs = new File(Prefs.guiCurrentDir, name);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(RB.getString((String)"other.Filters.pdf"), "pdf");
        String filename = FlapjackUtils.getSaveFilename(RB.getString((String)"gui.dendrogram.DendrogramPanelNB.saveAs"), saveAs, filter);
        if (filename != null) {
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(saveAs));
                byte[] data = this.dendrogram.getPdf().data;
                out.write(data, 0, data.length);
                out.close();
                TaskDialog.info((String)RB.format((String)"gui.dendrogram.DendrogramPanelNB.saveAsSuccess", (Object[])new Object[]{saveAs.getPath()}), (String)RB.getString((String)"gui.text.close"));
            }
            catch (Exception e) {
                TaskDialog.error((String)RB.format((String)"gui.dendrogram.DendrogramPanelNB.saveAsFail", (Object[])new Object[]{e.getMessage()}), (String)RB.getString((String)"gui.text.close"));
            }
        }
    }

    private void initComponents() {
        this.sp = new JScrollPane();
        this.bExportPNG = new JButton();
        this.bExportPDF = new JButton();
        this.bExportPNG.setText("Export as PNG");
        this.bExportPDF.setText("Export as PDF");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(182, Short.MAX_VALUE).addComponent(this.bExportPNG).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bExportPDF).addContainerGap()).addComponent(this.sp));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.sp, -1, 23, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bExportPNG).addComponent(this.bExportPDF)).addContainerGap()));
    }
}

