/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import jhi.flapjack.analysis.MabcAnalysis;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.gui.mabc.MabcTableModel;
import jhi.flapjack.gui.table.LineDataTable;
import jhi.flapjack.gui.table.LineDataTableExporter;
import jhi.flapjack.io.FlapjackFile;
import jhi.flapjack.io.cmd.CreateProject;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class GenerateMabcStats {
    private DataSet dataSet = new DataSet();
    private File mapFile;
    private File genotypesFile;
    private File qtlFile;
    private double maxMarkerCoverage = 10.0;
    private boolean decimalEnglish = false;
    private String filename;
    private boolean unweighted = false;
    private Integer parent1;
    private Integer parent2;

    public static void main(String[] args) {
        GenerateMabcStats mabcStats = new GenerateMabcStats(args);
        mabcStats.doStatGeneration();
        System.exit(0);
    }

    private GenerateMabcStats(String[] args) {
        NumberFormat nf = NumberFormat.getInstance();
        for (String arg : args) {
            String modelType;
            if (arg.startsWith("-map=")) {
                this.mapFile = new File(arg.substring(5));
            }
            if (arg.startsWith("-genotypes=")) {
                this.genotypesFile = new File(arg.substring(11));
            }
            if (arg.startsWith("-qtls=")) {
                this.qtlFile = new File(arg.substring(6));
            }
            if (arg.startsWith("-parent1=")) {
                this.parent1 = GenerateMabcStats.parseParent(arg.substring(9));
            }
            if (arg.startsWith("-parent2=")) {
                this.parent2 = GenerateMabcStats.parseParent(arg.substring(9));
            }
            if (arg.startsWith("-decimalEnglish")) {
                this.decimalEnglish = true;
            }
            if (arg.startsWith("-output=")) {
                this.filename = arg.substring(8);
            }
            if (arg.startsWith("-model=") && (modelType = arg.substring(7)).equals("unweighted")) {
                this.unweighted = true;
            }
            if (!arg.startsWith("-coverage=")) continue;
            try {
                this.maxMarkerCoverage = nf.parse(arg.substring(10)).doubleValue();
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (this.mapFile == null || this.genotypesFile == null || this.qtlFile == null || this.filename == null || this.parent1 == null || this.parent2 == null) {
            GenerateMabcStats.printHelp();
        }
    }

    private static Integer parseParent(String parent) {
        Integer parentIndex = null;
        try {
            parentIndex = Integer.parseInt(parent) - 1;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return parentIndex;
    }

    public void doStatGeneration() {
        RB.initialize((String)"auto", (String)"res.text.flapjack");
        TaskDialog.setIsHeadless();
        if (this.decimalEnglish) {
            Locale.setDefault(Locale.UK);
        }
        CreateProject createProject = new CreateProject(this.mapFile, this.genotypesFile, null, this.qtlFile, new FlapjackFile("temp"), false);
        try {
            createProject.createProject();
            this.dataSet = createProject.dataSet();
            this.generateMabcStats();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void generateMabcStats() throws Exception {
        GTViewSet viewSet = this.dataSet.getViewSets().get(0);
        boolean[] chromosomes = new boolean[viewSet.chromosomeCount()];
        for (int i = 0; i < chromosomes.length; ++i) {
            chromosomes[i] = true;
        }
        MabcAnalysis stats = new MabcAnalysis(viewSet, chromosomes, this.maxMarkerCoverage, this.parent1, this.parent2, this.unweighted);
        stats.runJob(0);
        MabcTableModel model = new MabcTableModel(viewSet);
        LineDataTable table = new LineDataTable();
        table.setModel(model);
        table.setViewSet(viewSet);
        LineDataTableExporter exporter = new LineDataTableExporter(table, new File(this.filename), 0, false);
        exporter.runJob(0);
    }

    private static void printHelp() {
        System.out.println("Usage: mabcstats <options>\n where valid options are:\n   -map=<map_file>                (required input file)\n   -genotypes=<genotypes_file>    (required input file)\n   -qtls=<qtl_file>               (required input file)\n   -parent1=<index_of_line>       (required parameter, index of recurrent parent, first line is index 1)\n   -parent2=<index_of_line>       (required parameter, index of donor parent, first line is index 1)\n   -model=weighted|unweighted     (optional parameter, defaults to weighted)\n   -coverage=<coverage_value>     (optional floating point parameter, defaults to 10)\n   -decimalEnglish                (optional parameter)\n   -output=<output_file>          (required output file)");
        System.exit(1);
    }
}

