/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import jhi.flapjack.io.ProjectSerializerDB;

public class FlapjackFile {
    public static final int UNKNOWN = 0;
    public static final int PROJECT_XML = 1;
    public static final int PROJECT_ZXML = 2;
    public static final int PROJECT_BIN = 3;
    public static final int MAP = 4;
    public static final int GENOTYPE = 5;
    public static final int PHENOTYPE = 6;
    public static final int QTL = 7;
    public static final int GRAPH = 8;
    public static final int WIGGLE = 9;
    public static final int HDF5 = 10;
    private String filename;
    private URL url;
    private File file;
    private int type = 0;

    public FlapjackFile(String filename) {
        this.filename = filename;
        try {
            this.url = new URL(filename);
        }
        catch (MalformedURLException e) {
            this.file = new File(filename);
        }
    }

    public int getType() {
        return this.type;
    }

    public String getPath() {
        return this.filename;
    }

    public String getName() {
        int slashIndex;
        if (this.file != null) {
            return this.file.getName();
        }
        String name = this.filename;
        if (name.indexOf("?") != -1) {
            name = name.substring(0, name.indexOf("?"));
        }
        if ((slashIndex = name.lastIndexOf("/")) != -1) {
            name = name.substring(slashIndex + 1);
        }
        return name;
    }

    long length() {
        if (this.file != null) {
            return this.file.length();
        }
        try {
            URLConnection conn = this.url.openConnection();
            conn.getInputStream().close();
            return conn.getContentLength();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public boolean exists() {
        if (this.file != null) {
            return this.file.exists();
        }
        try {
            URLConnection conn = this.url.openConnection();
            conn.getInputStream().close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        return this.url.openStream();
    }

    URL getURL() {
        return this.url;
    }

    public boolean isURL() {
        return this.url != null;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isProjectFile() {
        try {
            if (ProjectSerializerDB.isDatabase(this)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.filename.toLowerCase().endsWith(".xml") || this.filename.toLowerCase().endsWith(".flapjack");
    }

    public boolean canDetermineType() {
        try {
            String str = this.getFirstLine();
            if (str != null) {
                if (this.isMap(str)) {
                    this.type = 4;
                } else if (this.isGenotype(str)) {
                    this.type = 5;
                } else if (this.isPhenotype(str)) {
                    this.type = 6;
                } else if (this.isQTL(str)) {
                    this.type = 7;
                } else if (this.isGraph(str)) {
                    this.type = 8;
                } else if (this.isWiggle(str)) {
                    this.type = 9;
                } else if (this.isHDF5(str)) {
                    this.type = 10;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println("Detected " + this.type);
        return this.type != 0;
    }

    private boolean isMap(String str) {
        return str.toLowerCase().startsWith("# fjfile = map");
    }

    private boolean isGenotype(String str) {
        return str.toLowerCase().startsWith("# fjfile = genotype") || str.toLowerCase().startsWith("# fjfile = allele_frequency");
    }

    private boolean isPhenotype(String str) {
        return str.toLowerCase().startsWith("# fjfile = phenotype");
    }

    private boolean isQTL(String str) {
        return str.toLowerCase().startsWith("# fjfile = qtl");
    }

    private boolean isGraph(String str) {
        return str.toLowerCase().startsWith("# fjfile = graph");
    }

    private boolean isWiggle(String str) {
        return str.toLowerCase().startsWith("track type=wiggle_0") || str.startsWith("#");
    }

    private boolean isHDF5(String str) {
        return str.contains("HDF");
    }

    private String getFirstLine() {
        try {
            InputStreamReader rd = new InputStreamReader(this.getInputStream());
            char[] buf = new char[2048];
            int num = rd.read(buf);
            ((Reader)rd).close();
            for (int c = 0; c < num; ++c) {
                if (buf[c] != '\n' && buf[c] != '\r') continue;
                return new String(buf, 0, c);
            }
            return new String(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

