/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HeterozygeousColorState;
import jhi.flapjack.gui.visualization.colors.HomozygousColorState;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;
import scri.commons.gui.RB;

public class SimpleTwoColorScheme
extends ColorScheme {
    protected ArrayList<ColorState> states = new ArrayList();

    public SimpleTwoColorScheme() {
    }

    public SimpleTwoColorScheme(GTView view, int w, int h) {
        super(view);
        AlleleState state;
        int i;
        String s1 = null;
        String s2 = null;
        for (i = 0; i < this.stateTable.size(); ++i) {
            state = this.stateTable.getAlleleState(i);
            if (!state.isUnknown() && state.isHomozygous() && s1 == null) {
                s1 = state.getState(0);
                continue;
            }
            if (state.isUnknown() || !state.isHomozygous() || s2 != null) continue;
            s2 = state.getState(0);
        }
        for (i = 0; i < this.stateTable.size(); ++i) {
            state = this.stateTable.getAlleleState(i);
            if (state.isUnknown()) {
                this.states.add(new SimpleColorState(state, Prefs.visColorBackground, w, h));
                continue;
            }
            if (state.isHomozygous() && state.getState(0).equals(s1)) {
                this.states.add(new HomozygousColorState(state, Prefs.visColorSimple2State1, w, h));
                continue;
            }
            if (state.isHomozygous() && state.getState(0).equals(s2)) {
                this.states.add(new HomozygousColorState(state, Prefs.visColorSimple2State2, w, h));
                continue;
            }
            if (state.isHomozygous()) {
                this.states.add(new HomozygousColorState(state, Prefs.visColorSimple2Other, w, h));
                continue;
            }
            Color c1 = Prefs.visColorSimple2Other;
            Color c2 = Prefs.visColorSimple2Other;
            if (state.getState(0).equals(s1)) {
                c1 = Prefs.visColorSimple2State1;
            } else if (state.getState(0).equals(s2)) {
                c1 = Prefs.visColorSimple2State2;
            }
            if (state.getState(1).equals(s1)) {
                c2 = Prefs.visColorSimple2State1;
            } else if (state.getState(1).equals(s2)) {
                c2 = Prefs.visColorSimple2State2;
            }
            this.states.add(new HeterozygeousColorState(state, Prefs.visColorSimple2Other, c1, c2, w, h));
        }
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getColor();
    }

    @Override
    public int getModel() {
        return 6;
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorSimple2Color");
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.SimpleTwoColorScheme");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimple2State1, RB.getString((String)"gui.visualization.colors.SimpleTwoColorScheme.state1")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimple2State2, RB.getString((String)"gui.visualization.colors.SimpleTwoColorScheme.state2")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimple2Other, RB.getString((String)"gui.visualization.colors.SimpleTwoColorScheme.other")));
        return colors;
    }

    @Override
    public void setColorSummaries(ArrayList<ColorScheme.ColorSummary> colors) {
        Prefs.visColorSimple2State1 = colors.get((int)0).color;
        Prefs.visColorSimple2State2 = colors.get((int)1).color;
        Prefs.visColorSimple2Other = colors.get((int)2).color;
    }
}

