/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.util.ArrayList;
import java.util.HashMap;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.XMLRoot;

public class StateTable
extends XMLRoot {
    private ArrayList<AlleleState> states = new ArrayList();
    private HashMap<String, AlleleState> rawToAlleleHash = new HashMap();

    public StateTable() {
    }

    public StateTable(int notused) {
        AlleleState unknown = new AlleleState("", true, "/");
        this.states.add(unknown);
        this.rawToAlleleHash.put("", unknown);
    }

    void validate() throws NullPointerException {
        this.states.forEach(AlleleState::validate);
    }

    public ArrayList<AlleleState> getStates() {
        return this.states;
    }

    public void setStates(ArrayList<AlleleState> states) {
        this.states = states;
    }

    public int size() {
        return this.states.size();
    }

    public AlleleState getAlleleState(int code) {
        return this.states.get(code);
    }

    public int getStateCode(String rawData, boolean create, String missingString, boolean useHetSep, String hetSepStr) {
        if (rawData.equals(missingString)) {
            return 0;
        }
        if (!useHetSep && rawData.length() > 0 && rawData.matches(rawData.charAt(0) + "{" + rawData.length() + "}+")) {
            rawData = "" + rawData.charAt(0);
        }
        if (this.rawToAlleleHash.containsKey(rawData)) {
            return this.states.indexOf(this.rawToAlleleHash.get(rawData));
        }
        if (!create) {
            return -1;
        }
        AlleleState newState = new AlleleState(rawData, useHetSep, hetSepStr);
        this.states.add(newState);
        this.rawToAlleleHash.put(rawData, newState);
        return this.states.size() - 1;
    }

    public int calculateHomozygousStateCount() {
        int count = 0;
        for (int i = 1; i < this.states.size(); ++i) {
            if (!this.states.get(i).isHomozygous()) continue;
            ++count;
        }
        return count;
    }

    public void deleteState(int index) {
        this.states.remove(index);
    }

    public boolean isHet(int stateIndex) {
        return !this.states.get(stateIndex).isHomozygous();
    }

    public boolean isHom(int stateIndex) {
        return this.states.get(stateIndex).isHomozygous();
    }

    public void resetTable() {
        AlleleState emptyState = this.states.get(0);
        this.states.clear();
        this.rawToAlleleHash.clear();
        this.states.add(emptyState);
        this.rawToAlleleHash.put("", emptyState);
    }

    public boolean containsNucleotides() {
        boolean A = false;
        boolean C = false;
        boolean G = false;
        boolean T = false;
        for (AlleleState state : this.states) {
            if (state.isHomozygous() && state.homzAllele().equals("A")) {
                A = true;
            }
            if (state.isHomozygous() && state.homzAllele().equals("C")) {
                C = true;
            }
            if (state.isHomozygous() && state.homzAllele().equals("G")) {
                G = true;
            }
            if (!state.isHomozygous() || !state.homzAllele().equals("T")) continue;
            T = true;
        }
        return A && C && G && T;
    }

    public boolean containsNucleotides01() {
        boolean a0 = false;
        boolean a1 = false;
        for (AlleleState state : this.states) {
            if (state.isHomozygous() && state.homzAllele().equals("0")) {
                a0 = true;
            }
            if (!state.isHomozygous() || !state.homzAllele().equals("1")) continue;
            a1 = true;
        }
        return this.containsNucleotides() && a0 && a1;
    }

    public boolean containsABHData() {
        boolean A = false;
        boolean B = false;
        boolean H = false;
        for (AlleleState state : this.states) {
            if (state.isHomozygous() && state.homzAllele().equals("A")) {
                A = true;
            }
            if (state.isHomozygous() && state.homzAllele().equals("B")) {
                B = true;
            }
            if (!state.isHomozygous() || !state.homzAllele().equals("H")) continue;
            H = true;
        }
        return A && B && H;
    }

    public boolean containsMagic() {
        if (this.states.size() != 9) {
            return false;
        }
        boolean[] values = new boolean[8];
        for (AlleleState state : this.states) {
            if (!state.isHomozygous()) continue;
            try {
                int i = Integer.parseInt(state.homzAllele());
                values[i - 1] = true;
            }
            catch (Exception exception) {}
        }
        for (Object b : (Object)values) {
            if (b != false) continue;
            return false;
        }
        return true;
    }

    public boolean containsBins() {
        for (AlleleState state : this.states) {
            if (!state.isHomozygous()) {
                return false;
            }
            if (state.isUnknown()) continue;
            try {
                Integer.parseInt(state.homzAllele());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public HashMap<String, String> uniqueAlleles() {
        HashMap<String, String> hashtable = new HashMap<String, String>();
        for (AlleleState state : this.states) {
            for (String allele : state.getStates()) {
                hashtable.put(allele, allele);
            }
        }
        return hashtable;
    }

    public float[][] calculateSimilarityMatrix() {
        float[][] matrix = new float[this.states.size()][this.states.size()];
        for (int i = 0; i < this.states.size(); ++i) {
            for (int j = 0; j < this.states.size(); ++j) {
                AlleleState s2;
                AlleleState s1;
                float score = i == 0 || j == 0 ? 0.0f : (i == j ? 1.0f : ((s1 = this.states.get(i)).matches(s2 = this.states.get(j)) ? 1.0f : (s1.matchesAnyAllele(s2) ? 0.5f : 0.0f)));
                matrix[i][j] = score;
            }
        }
        return matrix;
    }
}

