/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.OverviewManager;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;

public class ImageExporter
extends SimpleJob {
    private GenotypePanel gPanel;
    private File file;
    private BufferedImage image;

    public ImageExporter(GenotypePanel gPanel, File file) {
        this.gPanel = gPanel;
        this.file = file;
    }

    public void runJob(int index) throws Exception {
        switch (Prefs.guiExportImageMethod) {
            case 0: {
                this.exportCurrentWindow();
                break;
            }
            case 1: {
                this.exportEntireView();
                break;
            }
            case 2: {
                this.exportOverview();
            }
        }
    }

    private void exportCurrentWindow() throws Error, Exception {
        this.image = this.gPanel.getCanvasBuffer(false);
        this.exportView(this.image, false);
    }

    private void exportOverview() throws Exception {
        int w = Prefs.guiExportImageX;
        int h = Prefs.guiExportImageY;
        this.image = OverviewManager.getExportableImage(w, h);
        if (this.image == null) {
            throw new RuntimeException(RB.getString((String)"io.ImageExporter.oomError"));
        }
        ImageIO.write((RenderedImage)this.image, "png", this.file);
    }

    private void exportEntireView() throws Error, Exception {
        this.image = this.gPanel.getCanvasBuffer(true);
        this.exportView(this.image, true);
    }

    private void exportView(BufferedImage image, Boolean full) throws Exception {
        BufferedImage finalImage;
        BufferedImage map = this.gPanel.getMapCanvasBuffer(full);
        BufferedImage lines = this.gPanel.getLineCanvasBuffer(full);
        BufferedImage traits = this.gPanel.getTraitCanvasBuffer(full);
        BufferedImage qtls = this.gPanel.getQTLCanvasBuffer(full);
        BufferedImage[] graphs = this.gPanel.getGraphCanvasBuffers(full);
        if (image == null) {
            throw new RuntimeException(RB.getString((String)"io.ImageExporter.noBufferError"));
        }
        int lineWidth = 0;
        if (Prefs.visShowLinePanel) {
            lineWidth = lines.getWidth();
        }
        int mapHeight = 0;
        if (Prefs.visShowMapCanvas) {
            mapHeight = map.getHeight();
        }
        int traitsWidth = 0;
        if (traits != null && Prefs.visShowTraitCanvas) {
            traitsWidth = traits.getWidth() + 5;
        }
        int qtlsHeight = 0;
        if (qtls != null && Prefs.visShowQTLCanvas) {
            qtlsHeight = qtls.getHeight();
        }
        int graphHeight = 0;
        if (Prefs.visShowGraphCanvas) {
            for (int i = 0; i < graphs.length; ++i) {
                if (graphs[i] == null) continue;
                graphHeight += graphs[i].getHeight() + 2;
            }
        }
        int w = lineWidth + image.getWidth() + traitsWidth;
        int h = qtlsHeight + image.getHeight() + mapHeight + graphHeight;
        try {
            finalImage = new BufferedImage(w, h, 1);
        }
        catch (Throwable t) {
            throw new RuntimeException(RB.getString((String)"io.ImageExporter.oomError"));
        }
        Graphics2D g = finalImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        if (Prefs.visShowQTLCanvas) {
            g.drawImage((Image)qtls, lineWidth + traitsWidth, 0, null);
        }
        if (Prefs.visShowMapCanvas) {
            g.drawImage((Image)map, lineWidth + traitsWidth, qtlsHeight, null);
        }
        if (Prefs.visShowTraitCanvas) {
            g.drawImage((Image)traits, 0, qtlsHeight + mapHeight, null);
        }
        if (Prefs.visShowLinePanel) {
            g.drawImage((Image)lines, traitsWidth, qtlsHeight + mapHeight, null);
        }
        g.drawImage((Image)image, lineWidth + traitsWidth, qtlsHeight + mapHeight, null);
        if (Prefs.visShowGraphCanvas) {
            int gh = 0;
            for (int i = 0; i < graphs.length; ++i) {
                g.drawImage((Image)graphs[i], lineWidth + traitsWidth, gh + qtlsHeight + mapHeight + image.getHeight() + 2, null);
                gh += graphs[i] != null ? graphs[i].getHeight() + 2 : 0;
            }
            g.fillRect(0, qtlsHeight + mapHeight + image.getHeight(), lineWidth + traitsWidth, graphHeight);
        }
        g.dispose();
        ImageIO.write((RenderedImage)finalImage, "png", this.file);
    }

    public boolean isIndeterminate() {
        return true;
    }

    public String getMessage() {
        return RB.format((String)"io.ImageExporter.message", (Object[])new Object[]{this.file.getName()});
    }
}

