/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Trait;
import jhi.flapjack.data.TraitValue;
import scri.commons.gui.SimpleJob;

public class TraitExporter
extends SimpleJob {
    private NumberFormat nf = NumberFormat.getInstance();
    private File file;
    private DataSet dataSet;

    public TraitExporter(DataSet dataSet, File file) {
        this.file = file;
        this.dataSet = dataSet;
        this.nf.setMaximumFractionDigits(6);
    }

    public void runJob(int index) throws Exception {
        ArrayList<Trait> traits = this.dataSet.getTraits();
        if (traits.isEmpty()) {
            return;
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
        out.write("# fjFile = PHENOTYPE");
        out.newLine();
        StringBuilder header = new StringBuilder();
        for (Trait trait : this.dataSet.getTraits()) {
            header.append("\t" + trait.getName());
        }
        out.write(header.toString());
        out.newLine();
        StringBuilder experiment = new StringBuilder();
        for (Trait trait : this.dataSet.getTraits()) {
            experiment.append("\t" + trait.getExperiment());
        }
        out.write(experiment.toString());
        out.newLine();
        for (Line line : this.dataSet.getLines()) {
            StringBuilder output = new StringBuilder(line.getName());
            for (TraitValue value : line.getTraitValues()) {
                if (value.isDefined()) {
                    if (value.getTrait().traitIsNumerical()) {
                        output.append("\t" + this.nf.format(value.getValue()));
                        continue;
                    }
                    output.append("\t" + value.getTrait().format(value));
                    continue;
                }
                output.append("\t");
            }
            out.write(output.toString());
            out.newLine();
        }
        out.close();
    }
}

