/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.HashMap;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.io.DataFormatException;
import jhi.flapjack.io.IGenotypeImporter;
import jhi.flapjack.io.MarkerIndex;
import scri.commons.gui.RB;
import scri.commons.io.ProgressInputStream;

public class GenotypeDataImporter
implements IGenotypeImporter {
    private ProgressInputStream is;
    private File file;
    private DataSet dataSet;
    private StateTable stateTable;
    private HashMap<String, MarkerIndex> markers;
    private HashMap<String, Line> lines;
    private HashMap<String, Integer> states = new HashMap();
    private String ioMissingData;
    private boolean ioUseHetSep;
    private String ioHeteroSeparator;
    private long lineCount = 0L;
    private long markerCount;
    private boolean useByteStorage = true;
    private boolean isOK = true;
    private boolean isTransposed;
    private NumberFormat nf = NumberFormat.getInstance();
    private boolean mapWasProvided;

    public GenotypeDataImporter(File file, DataSet dataSet, HashMap<String, MarkerIndex> markers, String ioMissingData, boolean ioUseHetSep, String ioHeteroSeparator, boolean isTransposed) {
        this.file = file;
        this.dataSet = dataSet;
        this.markers = markers;
        this.ioMissingData = ioMissingData;
        this.ioUseHetSep = ioUseHetSep;
        this.ioHeteroSeparator = ioHeteroSeparator;
        this.isTransposed = isTransposed;
        this.stateTable = dataSet.getStateTable();
        this.mapWasProvided = markers.size() > 0;
    }

    @Override
    public void cleanUp() {
        this.markers.clear();
        this.lines.clear();
    }

    @Override
    public void cancelImport() {
        this.isOK = false;
    }

    @Override
    public long getLineCount() {
        return this.dataSet.getLines().size();
    }

    @Override
    public long getMarkerCount() {
        return this.markerCount;
    }

    @Override
    public void importGenotypeData() throws IOException, DataFormatException {
        if (!this.readData(this.isTransposed)) {
            this.dataSet.getLines().clear();
            this.stateTable.resetTable();
            this.states.clear();
            this.useByteStorage = false;
            this.lineCount = 0L;
            this.readData(this.isTransposed);
        }
    }

    private boolean readData(boolean isTransposed) throws IOException, DataFormatException {
        if (isTransposed) {
            return this.readTransposedData();
        }
        return this.readNonTransposedData();
    }

    private MarkerIndex queryMarker(String name) {
        if (this.mapWasProvided) {
            return this.markers.get(name);
        }
        if (this.markers.get(name) != null) {
            return null;
        }
        int position = this.markers.size();
        Marker marker = new Marker(name, (double)position);
        ChromosomeMap map = this.dataSet.getChromosomeMaps().get(0);
        map.addMarker(marker);
        map.setLength(position);
        MarkerIndex mi = new MarkerIndex(0, this.markers.size());
        this.markers.put(marker.getName(), mi);
        return mi;
    }

    private boolean readNonTransposedData() throws IOException, DataFormatException {
        long s = System.currentTimeMillis();
        this.lines = new HashMap();
        this.is = new ProgressInputStream((InputStream)new FileInputStream(this.file));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)this.is, "UTF-8"));
        String str = in.readLine();
        while (str.length() == 0 || str.startsWith("#")) {
            this.processHeader(str);
            str = in.readLine();
            ++this.lineCount;
        }
        String[] markerNames = str.split("\t");
        int[] mapIndex = new int[markerNames.length];
        int[] mkrIndex = new int[markerNames.length];
        for (int i = 1; i < markerNames.length && this.isOK; ++i) {
            MarkerIndex index = this.queryMarker(markerNames[i].trim());
            if (index != null) {
                mapIndex[i] = index.mapIndex;
                mkrIndex[i] = index.mkrIndex;
                continue;
            }
            mkrIndex[i] = -1;
            mapIndex[i] = -1;
        }
        System.out.println("Map/marker cache created in " + (System.currentTimeMillis() - s) + "ms");
        s = System.currentTimeMillis();
        while ((str = in.readLine()) != null && this.isOK) {
            String[] values;
            if (str.length() == 0) continue;
            if (++this.lineCount % 100L == 0L) {
                System.out.println("Reading line " + this.lineCount + " (" + (System.currentTimeMillis() - s) + "ms)");
                s = System.currentTimeMillis();
            }
            if ((values = str.trim().split("\t")).length == 0) continue;
            String name = values[0].trim();
            if (this.lines.get(name) != null && !Prefs.ioAllowDupLines) {
                throw new DataFormatException(RB.format((String)"io.DataFormatException.duplicateLineError", (Object[])new Object[]{name, this.lineCount + 1L}));
            }
            Line line = this.dataSet.createLine(name, this.useByteStorage);
            this.lines.put(name, line);
            for (int i = 1; i < values.length; ++i) {
                if (mapIndex[i] == -1) continue;
                Integer stateCode = this.states.get(values[i]);
                if (stateCode == null) {
                    stateCode = this.stateTable.getStateCode(values[i], true, this.ioMissingData, this.ioUseHetSep, this.ioHeteroSeparator);
                    this.states.put(values[i], stateCode);
                }
                line.setLoci(mapIndex[i], mkrIndex[i], stateCode);
                ++this.markerCount;
            }
            if (!this.useByteStorage || this.stateTable.size() <= 127) continue;
            return false;
        }
        in.close();
        this.markers.clear();
        return true;
    }

    private void processHeader(String str) {
        if (str.indexOf(61) != -1) {
            try {
                String key = str.substring(1, str.indexOf(61)).trim();
                String value = str.substring(str.indexOf(61) + 1).trim();
                if (key.equals("fjDatabaseLineSearch")) {
                    this.dataSet.getDbAssociation().setLineSearch(value);
                }
                if (key.equals("fjDatabaseMarkerSearch")) {
                    this.dataSet.getDbAssociation().setMarkerSearch(value);
                }
                if (key.equals("fjDatabaseGroupPreview")) {
                    this.dataSet.getDbAssociation().setGroupPreview(value);
                }
                if (key.equals("fjDatabaseGroupUpload")) {
                    this.dataSet.getDbAssociation().setGroupUpload(value);
                }
            }
            catch (Exception e) {
                System.out.println("Invalid header: " + str);
            }
        } else if (str.startsWith("# bin")) {
            String[] tokens = str.split("\t");
            int index = Integer.parseInt(tokens[1]);
            try {
                float min = this.nf.parse(tokens[2]).floatValue();
                float max = this.nf.parse(tokens[3]).floatValue();
                this.dataSet.getBinnedData().addBin(index, min, max);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public long getBytesRead() {
        return this.is == null ? 0L : this.is.getBytesRead();
    }

    private boolean readTransposedData() throws IOException, DataFormatException {
        long s = System.currentTimeMillis();
        this.lines = new HashMap();
        this.is = new ProgressInputStream((InputStream)new FileInputStream(this.file));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)this.is, "UTF-8"));
        String str = in.readLine();
        while (str.length() == 0 || str.startsWith("#")) {
            this.processHeader(str);
            str = in.readLine();
            ++this.lineCount;
        }
        String[] lineNames = str.split("\t");
        for (int i = 1; i < lineNames.length && this.isOK; ++i) {
            lineNames[i] = lineNames[i].trim();
            if (this.lines.get(lineNames[i]) != null) {
                if (Prefs.ioAllowDupLines) continue;
                throw new DataFormatException(RB.format((String)"io.DataFormatException.duplicateLineError", (Object[])new Object[]{lineNames[i], this.lineCount + 1L}));
            }
            Line line = this.dataSet.createLine(lineNames[i], this.useByteStorage);
            this.lines.put(line.getName(), line);
        }
        while ((str = in.readLine()) != null && this.isOK) {
            String[] values;
            if (str.length() == 0 || str.startsWith("#")) continue;
            if (++this.lineCount % 100L == 0L) {
                System.out.println("Reading line " + this.lineCount + " (" + (System.currentTimeMillis() - s) + "ms)");
                s = System.currentTimeMillis();
            }
            if ((values = str.trim().split("\t")).length == 0) continue;
            for (int i = 1; i < values.length; ++i) {
                MarkerIndex index = this.queryMarker(values[0].trim());
                if (index == null || index.mapIndex == -1) continue;
                Integer stateCode = this.states.get(values[i]);
                if (stateCode == null) {
                    stateCode = this.stateTable.getStateCode(values[i], true, this.ioMissingData, this.ioUseHetSep, this.ioHeteroSeparator);
                    this.states.put(values[i], stateCode);
                }
                this.lines.get(lineNames[i]).setLoci(index.mapIndex, index.mkrIndex, stateCode);
                ++this.markerCount;
            }
            if (!this.useByteStorage || this.stateTable.size() <= 127) continue;
            return false;
        }
        in.close();
        this.markers.clear();
        return true;
    }
}

