/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HomozygousColorState;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;
import scri.commons.gui.RB;

public class BinnedColorScheme
extends ColorScheme {
    protected ArrayList<ColorState> states = new ArrayList();

    public BinnedColorScheme() {
    }

    public BinnedColorScheme(GTView view, int w, int h) {
        super(view);
        this.create(w, h);
    }

    public BinnedColorScheme(StateTable stateTable, int w, int h) {
        this.stateTable = stateTable;
        this.create(w, h);
    }

    private void create(int w, int h) {
        Object state;
        Color col1 = Prefs.visColorBinnedLow;
        int[] c1 = new int[]{col1.getRed(), col1.getGreen(), col1.getBlue()};
        Color col2 = Prefs.visColorBinnedHigh;
        int[] c2 = new int[]{col2.getRed(), col2.getGreen(), col2.getBlue()};
        Integer binCount = null;
        for (int i = 1; i < this.stateTable.size(); ++i) {
            state = this.stateTable.getAlleleState(i);
            if (!((AlleleState)state).isHomozygous()) continue;
            try {
                int bin = Integer.parseInt(((AlleleState)state).homzAllele());
                if (binCount != null && bin <= binCount) continue;
                binCount = bin;
                continue;
            }
            catch (NumberFormatException bin) {
                // empty catch block
            }
        }
        if (binCount != null) {
            Integer i = binCount;
            binCount = binCount + 1;
            state = binCount;
        } else {
            binCount = this.stateTable.size() - 1;
        }
        for (int i = 0; i < this.stateTable.size(); ++i) {
            state = this.stateTable.getAlleleState(i);
            if (((AlleleState)state).isUnknown()) {
                this.states.add(new SimpleColorState((AlleleState)state, Prefs.visColorBackground, w, h));
                continue;
            }
            if (!((AlleleState)state).isHomozygous()) continue;
            try {
                int bin = Integer.parseInt(((AlleleState)state).homzAllele());
                float f = (float)bin * (1.0f / ((float)binCount.intValue() - 1.0f));
                float f1 = (float)(1.0 - (double)f);
                float f2 = f;
                Color color = new Color((int)(f1 * (float)c1[0] + f2 * (float)c2[0]), (int)(f1 * (float)c1[1] + f2 * (float)c2[1]), (int)(f1 * (float)c1[2] + f2 * (float)c2[2]));
                this.states.add(new HomozygousColorState((AlleleState)state, color, w, h));
                continue;
            }
            catch (Exception e) {
                this.states.add(new HomozygousColorState((AlleleState)state, Prefs.visColorSimple2Other, w, h));
            }
        }
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getColor();
    }

    public Color getColor(int bin) {
        return this.states.get(bin + 1).getColor();
    }

    @Override
    public int getModel() {
        return 9;
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorBinned");
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.BinnedColorScheme");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorBinnedLow, "Low"));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorBinnedHigh, "High"));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorBinnedOther, "Other"));
        return colors;
    }

    @Override
    public void setColorSummaries(ArrayList<ColorScheme.ColorSummary> colors) {
        Prefs.visColorBinnedLow = colors.get((int)0).color;
        Prefs.visColorBinnedHigh = colors.get((int)1).color;
        Prefs.visColorBinnedOther = colors.get((int)2).color;
    }
}

