/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.ArrayList;
import jhi.flapjack.data.TraitColors;
import jhi.flapjack.data.TraitValue;
import jhi.flapjack.data.XMLRoot;
import scri.commons.gui.RB;

public class Trait
extends XMLRoot {
    private static final int UNKNOWN = 0;
    private static final int NUMERICAL = 1;
    private static final int CATEGORICAL = 2;
    private static NumberFormat nf = NumberFormat.getInstance();
    private String name;
    private ArrayList<String> categories = new ArrayList();
    private TraitColors colors = new TraitColors();
    private String experiment;
    private int type = 0;
    float min = Float.MAX_VALUE;
    float max = Float.MIN_VALUE;

    public Trait() {
    }

    public Trait(String name) {
        this.name = name;
        this.experiment = RB.getString((String)"data.Trait.notDefined");
    }

    void validate() throws NullPointerException {
        if (this.experiment == null) {
            this.experiment = RB.getString((String)"data.Trait.notDefined");
        }
        if (this.name == null) {
            throw new NullPointerException();
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<String> getCategories() {
        return this.categories;
    }

    public void setCategories(ArrayList<String> categories) {
        this.categories = categories;
    }

    public String getExperiment() {
        return this.experiment;
    }

    public void setExperiment(String experiment) {
        this.experiment = experiment;
    }

    public TraitColors getColors() {
        return this.colors;
    }

    public void setColors(TraitColors colors) {
        this.colors = colors;
    }

    public float computeValue(String token) throws Exception {
        float value = this.getNumCatValue(token);
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
        return value;
    }

    private float getNumCatValue(String token) throws Exception {
        if (this.type == 0 || this.type == 1) {
            try {
                float value = nf.parse(token).floatValue();
                this.type = 1;
                return value;
            }
            catch (Exception value) {
                // empty catch block
            }
        }
        if (this.type == 1) {
            throw new Exception("NumericalReadError");
        }
        this.type = 2;
        for (int i = 0; i < this.categories.size(); ++i) {
            if (!this.categories.get(i).equals(token)) continue;
            return i;
        }
        this.categories.add(token);
        return this.categories.size() - 1;
    }

    public boolean traitIsNumerical() {
        return this.categories.size() == 0;
    }

    public boolean experimentDefined() {
        return !this.experiment.equals(RB.getString((String)"data.Trait.notDefined"));
    }

    public String format(TraitValue tv) {
        int index = (int)tv.getValue();
        try {
            return this.categories.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "UNDEFINED";
        }
    }

    Color displayColor(float value, float normal) {
        return this.colors.displayColor(this, value, normal);
    }
}

