/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.File;
import java.text.NumberFormat;
import jhi.flapjack.analysis.MabcAnalysis;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.gui.mabc.MabcTableModel;
import jhi.flapjack.gui.table.LineDataTable;
import jhi.flapjack.gui.table.LineDataTableExporter;
import jhi.flapjack.io.cmd.CmdOptions;
import jhi.flapjack.io.cmd.CreateProject;
import jhi.flapjack.io.cmd.CreateProjectSettings;
import jhi.flapjack.io.cmd.DataImportSettings;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class GenerateMabcStats {
    private DataSet dataSet = new DataSet();
    private CreateProjectSettings projectSettings;
    private DataImportSettings importSettings;
    private double maxMarkerCoverage = 10.0;
    private String filename;
    private boolean excludeAdditionalParents = false;
    private boolean unweighted = false;
    private Integer parent1;
    private Integer parent2;
    CreateProject createProject;

    public static void main(String[] args) {
        NumberFormat nf = NumberFormat.getInstance();
        CmdOptions options = new CmdOptions().withAdvancedOptions().withGenotypeFile(true).withMapFile(true).withQtlFile(true).withOutputPath(true).withProjectFile(false).withTraitFile(false).addRequiredOption("r", "recurrent-parent", true, "INTEGER", "Index of parent in file").addRequiredOption("d", "donor-parent", true, "INTEGER", "Index of parent in file").addOption(null, "model", true, "ARG", "weighted|unweighted").addOption("c", "max-marker-coverage", true, "FLOATING POINT NUMBER", "Maximum coverage a marker can have in the weighted model").addOption("e", "exclude-additional-parents", "Exclude parents which are not the selected recurrent, or donor, parent from the analysis");
        try {
            CommandLine line = new DefaultParser().parse((Options)options, args);
            CreateProjectSettings projectSettings = options.getCreateProjectSettings(line);
            DataImportSettings importSettings = options.getDataImportSettings(line);
            String filename = options.getOutputPath(line);
            Integer parent1 = GenerateMabcStats.parseParent(line.getOptionValue("recurrent-parent"));
            Integer parent2 = GenerateMabcStats.parseParent(line.getOptionValue("donor-parent"));
            String modelType = line.getOptionValue("model");
            boolean unweighted = modelType != null && modelType.equals("unweighted");
            double maxMarkerCoverage = 10.0;
            if (line.hasOption("max-marker-coverage")) {
                maxMarkerCoverage = nf.parse(line.getOptionValue("max-marker-coverage")).doubleValue();
            }
            boolean excludeAdditionalParents = line.hasOption("exclude-additional-parents");
            GenerateMabcStats mabcStats = new GenerateMabcStats(projectSettings, importSettings, parent1, parent2, excludeAdditionalParents, unweighted, maxMarkerCoverage, filename);
            mabcStats.doStatGeneration();
            System.exit(0);
        }
        catch (Exception e) {
            options.printHelp("GenerateMabcStats");
            System.exit(1);
        }
    }

    private GenerateMabcStats(CreateProjectSettings projectSettings, DataImportSettings importSettings, Integer parent1, Integer parent2, boolean excludeAdditionalParents, boolean unweighted, double maxMarkerCoverage, String filename) {
        this.projectSettings = projectSettings;
        this.importSettings = importSettings;
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.excludeAdditionalParents = excludeAdditionalParents;
        this.unweighted = unweighted;
        this.maxMarkerCoverage = maxMarkerCoverage;
        this.filename = filename;
    }

    private static Integer parseParent(String parent) {
        Integer parentIndex = null;
        try {
            parentIndex = Integer.parseInt(parent) - 1;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return parentIndex;
    }

    public void doStatGeneration() {
        RB.initialize((String)"auto", (String)"res.text.flapjack");
        TaskDialog.setIsHeadless();
        this.createProject = new CreateProject(this.projectSettings, this.importSettings);
        try {
            this.createProject.doProjectCreation();
            this.dataSet = this.createProject.dataSet();
            this.generateMabcStats();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void generateMabcStats() throws Exception {
        GTViewSet viewSet = this.dataSet.getViewSets().get(0);
        boolean[] chromosomes = new boolean[viewSet.chromosomeCount()];
        for (int i = 0; i < chromosomes.length; ++i) {
            chromosomes[i] = true;
        }
        MabcAnalysis stats = new MabcAnalysis(viewSet, chromosomes, this.maxMarkerCoverage, this.parent1, this.parent2, this.excludeAdditionalParents, this.unweighted, RB.getString((String)"gui.navpanel.MabcNode.node"));
        stats.runJob(0);
        GTViewSet finalViewSet = stats.getViewSet();
        MabcTableModel model = new MabcTableModel(finalViewSet);
        LineDataTable table = new LineDataTable();
        table.setModel(model);
        table.setViewSet(finalViewSet);
        LineDataTableExporter exporter = new LineDataTableExporter(table, new File(this.filename), 0, false);
        exporter.runJob(0);
        this.createProject.saveProject();
    }
}

