/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HeterozygeousColorState;
import jhi.flapjack.gui.visualization.colors.HomozygousColorState;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;
import scri.commons.gui.RB;

public class ParentTotalMatchColorScheme
extends ColorScheme {
    protected ArrayList<ColorState> p1States = new ArrayList();
    protected ArrayList<ColorState> p2States = new ArrayList();
    protected ArrayList<ColorState> matchStates = new ArrayList();
    protected ArrayList<ColorState> noMatchStates = new ArrayList();
    protected ArrayList<ColorState> gsStates = new ArrayList();
    protected HashMap<String, ColorState> progenyStates = new HashMap();

    public ParentTotalMatchColorScheme() {
    }

    public ParentTotalMatchColorScheme(GTView view, int w, int h) {
        super(view);
        int i;
        Color sHz = Prefs.visColorNucleotideHZ;
        Color cp1 = Prefs.visParentSimilarity1;
        Color cp2 = Prefs.visParentSimilarity2;
        Color stateMatch = Prefs.visColorSimStateMatch;
        Color stateNoMatch = Prefs.visColorSimStateNoMatch;
        Color gsC = Prefs.visColorSimStateMissing;
        for (i = 0; i < this.stateTable.size(); ++i) {
            ColorState comp;
            ColorState comp2;
            ColorState match;
            ColorState noMatch;
            ColorState grey;
            AlleleState state = this.stateTable.getAlleleState(i);
            if (state.isUnknown()) {
                noMatch = grey = new SimpleColorState(state, Prefs.visColorBackground, w, h);
                match = grey;
                comp2 = grey;
                comp = grey;
            } else if (state.isHomozygous()) {
                comp = new HomozygousColorState(state, cp1, w, h);
                comp2 = new HomozygousColorState(state, cp2, w, h);
                match = new HomozygousColorState(state, stateMatch, w, h);
                noMatch = new HomozygousColorState(state, stateNoMatch, w, h);
                grey = new HomozygousColorState(state, gsC, w, h);
            } else {
                comp = new HeterozygeousColorState(state, sHz, cp1, cp1, w, h);
                comp2 = new HeterozygeousColorState(state, sHz, cp2, cp2, w, h);
                match = new HeterozygeousColorState(state, sHz, stateMatch, stateMatch, w, h);
                noMatch = new HeterozygeousColorState(state, sHz, stateNoMatch, stateNoMatch, w, h);
                grey = new HeterozygeousColorState(state, sHz, gsC, gsC, w, h);
            }
            this.p1States.add(comp);
            this.p2States.add(comp2);
            this.matchStates.add(match);
            this.noMatchStates.add(noMatch);
            this.gsStates.add(grey);
        }
        for (i = 0; i < this.stateTable.size(); ++i) {
            AlleleState p1State = this.stateTable.getAlleleState(i);
            for (int j = 0; j < this.stateTable.size(); ++j) {
                AlleleState p2State = this.stateTable.getAlleleState(j);
                for (int k = 0; k < this.stateTable.size(); ++k) {
                    AlleleState progState = this.stateTable.getAlleleState(k);
                    String key = i + ":" + j + ":" + k;
                    if (progState.isUnknown()) {
                        this.progenyStates.put(key, this.matchStates.get(k));
                        continue;
                    }
                    if (p1State.isUnknown() && p2State.isUnknown()) {
                        this.progenyStates.put(key, this.gsStates.get(k));
                        continue;
                    }
                    if (p1State.isUnknown() || p2State.isUnknown() || progState.allelesContainedInParents(p1State, p2State)) {
                        this.progenyStates.put(key, this.matchStates.get(k));
                        continue;
                    }
                    this.progenyStates.put(key, this.noMatchStates.get(k));
                }
            }
        }
    }

    @Override
    public void setColorSummaries(ArrayList<ColorScheme.ColorSummary> colors) {
        Prefs.visColorSimStateMatchDark = colors.get((int)0).color;
        Prefs.visColorSimStateMatch = colors.get((int)1).color;
        Prefs.visColorSimStateNoMatch = colors.get((int)2).color;
        Prefs.visColorSimStateMissing = colors.get((int)3).color;
    }

    protected ColorState getState(int line, int marker) {
        int p1 = this.view.getViewSet().getComparisonLineIndex();
        int p2 = this.view.getViewSet().getComparisonLineIndex2();
        int state = this.view.getState(line, marker);
        if (p1 != -1 && p2 != -1) {
            int p1State = this.view.getState(p1, marker);
            int p2State = this.view.getState(p2, marker);
            if (line == p1) {
                return this.p1States.get(state);
            }
            if (line == p2) {
                return this.p2States.get(state);
            }
            return this.progenyStates.get(p1State + ":" + p2State + ":" + state);
        }
        return this.gsStates.get(state);
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        return this.getState(line, marker).getColor();
    }

    @Override
    public int getModel() {
        return 15;
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.ParentTotalMatchColorScheme");
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorParentTotal");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        colors.add(new ColorScheme.ColorSummary(Prefs.visParentSimilarity1, RB.getString((String)"gui.visualization.colors.ParentTotalMatchColorScheme.parent1")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visParentSimilarity2, RB.getString((String)"gui.visualization.colors.ParentTotalMatchColorScheme.parent2")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateMatch, RB.getString((String)"gui.visualization.colors.ParentTotalMatchColorScheme.state1")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateNoMatch, RB.getString((String)"gui.visualization.colors.ParentTotalMatchColorScheme.state2")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateMissing, RB.getString((String)"gui.visualization.colors.ParentTotalMatchColorScheme.state3")));
        return colors;
    }
}

