/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.util.ArrayList;
import java.util.stream.Collectors;
import jhi.flapjack.data.Bookmark;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.CustomMaps;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.UndoManager;
import jhi.flapjack.data.XMLRoot;
import jhi.flapjack.data.results.Dendrogram;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.gui.table.LinkedTableHandler;
import scri.commons.MatrixXML;

public class GTViewSet
extends XMLRoot {
    private DataSet dataSet;
    private ArrayList<GTView> views = new ArrayList();
    private CustomMaps customMaps = new CustomMaps();
    ArrayList<LineInfo> lines = new ArrayList();
    ArrayList<LineInfo> hideLines = new ArrayList();
    private ArrayList<Bookmark> bookmarks = new ArrayList();
    private ArrayList<SimMatrix> matrices = new ArrayList();
    private ArrayList<Dendrogram> dendrograms = new ArrayList();
    private String name;
    private int viewIndex;
    private int colorScheme;
    private float alleleFrequencyThreshold = 0.05f;
    private int randomColorSeed = (int)(Math.random() * 50000.0);
    Line comparisonLine;
    Line comparisonLine2;
    int comparisonLineIndex;
    int comparisonLineIndex2;
    private int[] traits = new int[0];
    private int[] txtTraits = new int[0];
    private int[] linkedModelCols = new int[0];
    private boolean displayLineScores = false;
    private int[] graphs = new int[]{0, -1, -1};
    private UndoManager undoManager = new UndoManager();
    private LinkedTableHandler tableHandler = new LinkedTableHandler(this);

    public GTViewSet() {
    }

    public GTViewSet(DataSet dataSet, String name) {
        this.dataSet = dataSet;
        this.name = name;
        this.lines = new ArrayList(dataSet.countLines());
        for (int i = 0; i < dataSet.countLines(); ++i) {
            Line line = dataSet.getLineByIndex(i);
            this.lines.add(new LineInfo(line, i));
        }
        int allChromosomesIndex = -1;
        for (int i = 0; i < dataSet.countChromosomeMaps(); ++i) {
            GTView view = new GTView(this, dataSet.getMapByIndex(i), true);
            view.linkMarkerInfos();
            this.views.add(view);
            if (!view.getChromosomeMap().isSpecialChromosome()) continue;
            allChromosomesIndex = i;
        }
        if (allChromosomesIndex != -1) {
            this.viewIndex = allChromosomesIndex;
        }
        this.assignTraits();
    }

    void validate() throws NullPointerException {
        if (this.dataSet == null || this.name == null || this.lines == null) {
            throw new NullPointerException();
        }
        for (GTView view : this.views) {
            view.validate();
        }
        for (LineInfo info : this.lines) {
            if (info.index == -1) {
                info.line = this.dataSet.getDummyLine();
                continue;
            }
            if (info.index != -2) continue;
            info.line = this.dataSet.getSplitter();
        }
        for (LineInfo lineInfo : this.hideLines) {
            if (lineInfo.getVisibility() != LineInfo.VISIBLE) continue;
            lineInfo.setVisibility(LineInfo.HIDDEN);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public ArrayList<LineInfo> getLines() {
        return this.lines;
    }

    public void setLines(ArrayList<LineInfo> lines) {
        this.lines = lines;
    }

    public ArrayList<LineInfo> getHideLines() {
        return this.hideLines;
    }

    public void setHideLines(ArrayList<LineInfo> hideLines) {
        this.hideLines = hideLines;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getViewIndex() {
        return this.viewIndex;
    }

    public void setViewIndex(int viewIndex) {
        this.viewIndex = viewIndex;
    }

    public ArrayList<GTView> getViews() {
        return this.views;
    }

    public void setViews(ArrayList<GTView> views) {
        this.views = views;
    }

    public CustomMaps getCustomMaps() {
        return this.customMaps;
    }

    public void setCustomMaps(CustomMaps customMaps) {
        this.customMaps = customMaps;
    }

    public ArrayList<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public void setBookmarks(ArrayList<Bookmark> bookmarks) {
        this.bookmarks = bookmarks;
    }

    public int getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(int colorScheme) {
        this.colorScheme = colorScheme;
    }

    public int getRandomColorSeed() {
        return this.randomColorSeed;
    }

    public void setRandomColorSeed(int randomColorSeed) {
        this.randomColorSeed = randomColorSeed;
    }

    public Line getComparisonLine() {
        return this.comparisonLine;
    }

    public void setComparisonLine(Line comparisonLine) {
        this.comparisonLine = comparisonLine;
    }

    public Line getComparisonLine2() {
        return this.comparisonLine2;
    }

    public void setComparisonLine2(Line comparisonLine2) {
        this.comparisonLine2 = comparisonLine2;
    }

    public int getComparisonLineIndex() {
        return this.comparisonLineIndex;
    }

    public void setComparisonLineIndex(int comparisonLineIndex) {
        this.comparisonLineIndex = comparisonLineIndex;
    }

    public int getComparisonLineIndex2() {
        return this.comparisonLineIndex2;
    }

    public void setComparisonLineIndex2(int comparisonLineIndex1) {
        this.comparisonLineIndex2 = comparisonLineIndex1;
    }

    public float getAlleleFrequencyThreshold() {
        return this.alleleFrequencyThreshold;
    }

    public void setAlleleFrequencyThreshold(float alleleFrequencyThreshold) {
        this.alleleFrequencyThreshold = alleleFrequencyThreshold;
    }

    public String getSelectedTraits() {
        return MatrixXML.arrayToString((int[])this.traits);
    }

    public void setSelectedTraits(String traitsStr) {
        this.traits = MatrixXML.stringToIntArray((String)traitsStr);
    }

    public String getSelectedTxtTraits() {
        return MatrixXML.arrayToString((int[])this.txtTraits);
    }

    public void setSelectedTxtTraits(String txtTraitsStr) {
        this.txtTraits = MatrixXML.stringToIntArray((String)txtTraitsStr);
    }

    public boolean getDisplayLineScores() {
        return this.displayLineScores;
    }

    public void setDisplayLineScores(boolean displayLineScores) {
        this.displayLineScores = displayLineScores;
    }

    public String getSelectedGraphs() {
        return MatrixXML.arrayToString((int[])this.graphs);
    }

    public void setSelectedGraphs(String graphs) {
        this.graphs = MatrixXML.stringToIntArray((String)graphs);
    }

    public ArrayList<SimMatrix> getMatrices() {
        return this.matrices;
    }

    public void setMatrices(ArrayList<SimMatrix> matrices) {
        this.matrices = matrices;
    }

    public ArrayList<Dendrogram> getDendrograms() {
        return this.dendrograms;
    }

    public void setDendrograms(ArrayList<Dendrogram> dendrograms) {
        this.dendrograms = dendrograms;
    }

    public LinkedTableHandler getTableHandler() {
        return this.tableHandler;
    }

    public void setTableHandler(LinkedTableHandler tableHandler) {
        this.tableHandler = tableHandler;
    }

    public int[] getTraits() {
        return this.traits;
    }

    public void setTraits(int[] traits) {
        this.traits = traits;
    }

    public int[] getTxtTraits() {
        return this.txtTraits;
    }

    public void setTxtTraits(int[] txtTraits) {
        this.txtTraits = txtTraits;
    }

    public int[] getGraphs() {
        return this.graphs;
    }

    public void setGraphs(int[] graphs) {
        this.graphs = graphs;
    }

    public int[] getLinkedModelCols() {
        return this.linkedModelCols;
    }

    public void setLinkedModelCols(int[] linkedModelCols) {
        this.linkedModelCols = linkedModelCols;
    }

    public LinkedTableHandler tableHandler() {
        return this.tableHandler;
    }

    public void addView(GTView view) {
        this.views.add(view);
    }

    public int chromosomeCount() {
        return this.views.size();
    }

    public GTView getView(int index) {
        return this.views.get(index);
    }

    public GTView getView(ChromosomeMap map) {
        for (GTView view : this.views) {
            if (view.getChromosomeMap() != map) continue;
            return view;
        }
        return null;
    }

    public ArrayList<LineInfo> copyLines(int visibility) {
        if (visibility == LineInfo.HIDDEN) {
            return this.hideLines.stream().filter(li -> li.visibility == LineInfo.HIDDEN).collect(Collectors.toCollection(ArrayList::new));
        }
        if (visibility == LineInfo.FILTERED) {
            return this.hideLines.stream().filter(li -> li.visibility == LineInfo.FILTERED).collect(Collectors.toCollection(ArrayList::new));
        }
        return this.lines.stream().collect(Collectors.toCollection(ArrayList::new));
    }

    public void setLinesFromCopies(ArrayList<LineInfo> lines, ArrayList<LineInfo> hidden, ArrayList<LineInfo> filtered) {
        this.lines.clear();
        this.lines.addAll(lines);
        lines.forEach(li -> {
            li.visibility = LineInfo.VISIBLE;
        });
        if (hidden != null && filtered != null) {
            this.hideLines.clear();
            this.hideLines.addAll(hidden);
            this.hideLines.addAll(filtered);
            hidden.forEach(li -> {
                li.visibility = LineInfo.HIDDEN;
            });
            filtered.forEach(li -> {
                li.visibility = LineInfo.FILTERED;
            });
        }
        this.tableHandler.copyViewToTable(true);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public String toString() {
        return this.name;
    }

    public GTViewSet createClone(String cloneName, boolean selectedLMOnly) {
        int i;
        GTViewSet clone = new GTViewSet(this.dataSet, cloneName);
        clone.colorScheme = this.colorScheme;
        clone.alleleFrequencyThreshold = this.alleleFrequencyThreshold;
        clone.randomColorSeed = this.randomColorSeed;
        clone.graphs = this.graphs;
        clone.traits = new int[this.traits.length];
        for (i = 0; i < this.traits.length; ++i) {
            clone.traits[i] = this.traits[i];
        }
        clone.txtTraits = new int[this.txtTraits.length];
        for (i = 0; i < this.txtTraits.length; ++i) {
            clone.txtTraits[i] = this.txtTraits[i];
        }
        clone.lines.clear();
        for (LineInfo lineInfo : this.lines) {
            if (selectedLMOnly && (!selectedLMOnly || !lineInfo.getSelected())) continue;
            clone.lines.add(new LineInfo(lineInfo));
        }
        if (!selectedLMOnly) {
            for (LineInfo lineInfo : this.hideLines) {
                clone.hideLines.add(new LineInfo(lineInfo));
            }
        }
        clone.comparisonLine = this.comparisonLine;
        clone.comparisonLine2 = this.comparisonLine2;
        clone.comparisonLineIndex = this.comparisonLineIndex;
        clone.comparisonLineIndex2 = this.comparisonLineIndex2;
        clone.views.clear();
        for (int i2 = 0; i2 < this.views.size(); ++i2) {
            GTView viewClone = this.views.get(i2).createClone(clone, selectedLMOnly);
            viewClone.linkMarkerInfos();
            clone.views.add(viewClone);
        }
        clone.removeAllDummyLines();
        clone.removeAllDuplicates();
        clone.removeSortSplitter();
        return clone;
    }

    public int countAllMarkers() {
        int count = 0;
        for (GTView view : this.views) {
            count += view.markerCount();
        }
        return count;
    }

    public int indexOf(Line line) {
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.lines.get((int)i).line != line) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(LineInfo line) {
        return this.lines.indexOf(line);
    }

    public int indexof(GTView view) {
        for (int i = 0; i < this.views.size(); ++i) {
            if (this.views.get(i) != view) continue;
            return i;
        }
        return -1;
    }

    public void assignTraits() {
        if (this.traits.length > 0) {
            return;
        }
        int count = this.dataSet.getTraits().size();
        int size = count < 3 ? count : 3;
        this.traits = new int[size];
        this.txtTraits = new int[size];
        for (int i = 0; i < this.traits.length; ++i) {
            this.traits[i] = i;
            this.txtTraits[i] = i;
        }
    }

    public void insertDummyLine(int index) {
        Line dummy = this.dataSet.getDummyLine();
        if (dummy == null) {
            Line line = this.lines.get((int)index).line;
            dummy = line.createDummy();
            this.dataSet.setDummyLine(dummy);
        }
        this.lines.add(index, new LineInfo(dummy, -1));
        this.tableHandler.copyViewToTable(true);
    }

    public void removeAllDummyLines() {
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            if (this.lines.get((int)i).line != this.dataSet.getDummyLine()) continue;
            this.lines.remove(i);
        }
        this.tableHandler.copyViewToTable(false);
    }

    public void removeAllDuplicates() {
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            if (!this.lines.get(i).getDuplicate()) continue;
            this.lines.remove(i);
        }
        this.tableHandler.copyViewToTable(false);
    }

    public void removeSortSplitter() {
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.lines.get(i).getLine() != this.dataSet.getSplitter()) continue;
            this.lines.remove(i);
            break;
        }
    }

    public void duplicateLine(int index) {
        LineInfo original = this.lines.get(index);
        LineInfo duplicate = original.makeDuplicate();
        this.lines.add(index + 1, duplicate);
        this.tableHandler.copyViewToTable(true);
    }

    public void insertSplitterLine(int index) {
        Line splitter = this.dataSet.getSplitter();
        if (splitter == null) {
            Line line = this.lines.get((int)index).line;
            splitter = line.createDummy();
            this.dataSet.setSplitter(splitter);
        }
        this.lines.add(index, new LineInfo(splitter, -2));
        this.tableHandler.copyViewToTable(true);
    }

    public void moveLine(int fromIndex, int toIndex) {
        if (toIndex < 0 || fromIndex < 0) {
            return;
        }
        if (toIndex >= this.lines.size() || fromIndex >= this.lines.size()) {
            return;
        }
        LineInfo oldValue = this.lines.get(fromIndex);
        this.lines.set(fromIndex, this.lines.get(toIndex));
        this.lines.set(toIndex, oldValue);
        if (this.comparisonLineIndex == fromIndex) {
            this.comparisonLineIndex = toIndex;
        } else if (this.comparisonLineIndex == toIndex) {
            this.comparisonLineIndex = fromIndex;
        }
        if (this.comparisonLineIndex2 == fromIndex) {
            this.comparisonLineIndex2 = toIndex;
        } else if (this.comparisonLineIndex2 == toIndex) {
            this.comparisonLineIndex2 = fromIndex;
        }
        this.tableHandler.copyViewToTable(true);
    }

    public void restoreHiddenLines() {
        for (LineInfo lineInfo : this.hideLines) {
            if (lineInfo.getVisibility() != LineInfo.HIDDEN) continue;
            this.lines.add(lineInfo);
        }
        this.hideLines.removeIf(li -> li.visibility == LineInfo.HIDDEN);
        for (LineInfo lineInfo : this.lines) {
            lineInfo.setVisibility(LineInfo.VISIBLE);
        }
        this.tableHandler().copyViewToTable(false);
        this.tableHandler().copyTableToView();
    }

    public long hiddenLineCount() {
        return this.hideLines.stream().filter(li -> li.getVisibility() == LineInfo.HIDDEN).count();
    }
}

