/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.MouseInputAdapter;
import jhi.flapjack.analysis.QTLTrackOptimiser;
import jhi.flapjack.data.FeatureGroup;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.MarkerInfo;
import jhi.flapjack.data.QTL;
import jhi.flapjack.data.QTLInfo;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.MapCanvas;
import jhi.flapjack.gui.visualization.undo.SelectedMarkersState;
import scri.commons.gui.RB;
import scri.commons.gui.SystemUtils;

class QTLCanvas
extends JPanel
implements PropertyChangeListener {
    private static final int H = 20;
    private static final int BORDER = 5;
    private GenotypePanel gPanel;
    private GenotypeCanvas canvas;
    private MapCanvas mapCanvas;
    private Canvas2D qtlCanvas;
    ArrayList<ArrayList<FeatureGroup>> trackSet;
    private int trackCount = 0;
    private int w;
    private double distance;
    private double mSPos;
    private double mEPos;
    private BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 2.0f}, 0.0f);
    private BasicStroke solid = new BasicStroke(1.0f);
    private int xOffset;
    private int mouseOverTrack = -1;
    static QTLInfo mouseOverQTL = null;
    boolean full = false;

    QTLCanvas(GenotypePanel gPanel, GenotypeCanvas canvas, MapCanvas mapCanvas) {
        this.gPanel = gPanel;
        this.canvas = canvas;
        this.mapCanvas = mapCanvas;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.qtlCanvas = new Canvas2D();
        this.add(this.qtlCanvas);
        QTLMouseListener ml = new QTLMouseListener();
        this.qtlCanvas.addMouseListener(ml);
        this.qtlCanvas.addMouseMotionListener(ml);
        this.qtlCanvas.setMinimumSize(new Dimension(0, 20));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        JSplitPane qtlSplitter = (JSplitPane)e.getSource();
        if (Prefs.visShowQTLCanvas && qtlSplitter.getDividerLocation() > 5) {
            Prefs.guiQTLSplitterLocation = qtlSplitter.getDividerLocation();
            this.updateCanvasSize(false);
        }
    }

    void updateCanvasSize(boolean forceUpdate) {
        if (this.canvas.view == null) {
            return;
        }
        int height = Prefs.guiQTLSplitterLocation - 5;
        int tracks = height / 20;
        if (forceUpdate || tracks != this.trackCount && tracks > 0) {
            QTLTrackOptimiser optimiser = new QTLTrackOptimiser();
            this.trackSet = optimiser.getTracks(tracks, this.canvas.view);
            this.trackCount = tracks;
        }
    }

    private void drawTracks(Graphics2D g) {
        this.distance = this.mEPos - this.mSPos;
        int trackNum = 0;
        for (ArrayList<FeatureGroup> trackData : this.trackSet) {
            int fgIndex;
            g.translate(0, 20 * trackNum);
            g.setColor(Color.lightGray);
            g.setStroke(this.dashed);
            g.drawLine(0, 10, this.w, 10);
            g.setStroke(this.solid);
            if (fgIndex != -1) {
                for (fgIndex = this.binarySearch(trackData, 0, trackData.size() - 1, this.mSPos, this.mEPos); fgIndex > 0 && trackData.get(fgIndex - 1).getMax() > this.mSPos; --fgIndex) {
                }
                for (FeatureGroup fg : trackData.subList(fgIndex, trackData.size())) {
                    if (fg.getMin() > this.mEPos) break;
                    boolean grouped = fg.size() > 1;
                    for (QTLInfo qtlInfo : fg) {
                        if (!(qtlInfo.max() > this.mSPos) || !(qtlInfo.min() < this.mEPos)) continue;
                        this.drawQTL(g, qtlInfo, trackNum, grouped);
                    }
                }
            }
            g.translate(0, -20 * trackNum);
            ++trackNum;
        }
        if (mouseOverQTL != null) {
            g.translate(0, 20 * this.mouseOverTrack);
            this.drawQTL(g, mouseOverQTL, this.mouseOverTrack, false);
        }
    }

    private int getPixelPosition(double mapPos) {
        return (int)((mapPos - this.mSPos) * ((double)(this.w - 1) / this.distance));
    }

    private double getMapPosition(int pixelPos) {
        return this.distance * (double)pixelPos / (double)(this.w - 1) + this.mSPos;
    }

    private void drawQTL(Graphics2D g, QTLInfo qtlInfo, int trackNum, boolean grouped) {
        int minX = this.getPixelPosition(qtlInfo.min());
        int maxX = this.getPixelPosition(qtlInfo.max());
        Color c = qtlInfo.getQTL().getDisplayColor();
        Color c1 = c.brighter();
        Color c2 = c.darker();
        g.setPaint(new GradientPaint(0.0f, 5.0f, c1, 0.0f, 10.0f, c2, true));
        g.fillRect(minX, 5, maxX - minX + 1, 10);
        if (grouped) {
            g.setColor(Color.black);
        } else if (this.mouseOverTrack == trackNum && mouseOverQTL == qtlInfo) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.lightGray);
        }
        g.drawRect(minX, 5, maxX - minX + 1, 10);
        int x = this.getPixelPosition(qtlInfo.displayPosition());
        g.drawLine(x, 2, x, 18);
    }

    private int binarySearch(ArrayList<FeatureGroup> trackData, int low, int high, double canvasLeft, double canvasRight) {
        if (high < low) {
            return -1;
        }
        int mid = low + (high - low) / 2;
        double max = trackData.get(mid).getMax();
        double min = trackData.get(mid).getMin();
        if (max < canvasLeft) {
            return this.binarySearch(trackData, mid + 1, high, canvasLeft, canvasRight);
        }
        if (min > canvasRight) {
            return this.binarySearch(trackData, low, mid - 1, canvasLeft, canvasRight);
        }
        return mid;
    }

    BufferedImage createSavableImage(boolean full) throws Exception {
        this.w = this.canvas.pX2 - this.canvas.pX1 + 1;
        int h = this.getHeight();
        if (full) {
            this.w = this.canvas.canvasW;
        }
        BufferedImage image = (BufferedImage)this.createImage(this.w > 0 ? this.w : 1, h > 0 ? h : 1);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, this.w, h);
        this.drawTracks(g);
        g.dispose();
        return image;
    }

    private class QTLMouseListener
    extends MouseInputAdapter {
        private boolean isOSX = SystemUtils.isMacOS();

        private QTLMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ((QTLCanvas)QTLCanvas.this).gPanel.statusPanel.setForFeatureUse();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.detectQTL(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            QTLCanvas.this.mouseOverTrack = -1;
            mouseOverQTL = null;
            ((QTLCanvas)QTLCanvas.this).gPanel.statusPanel.setQTLDetails(null);
            ((QTLCanvas)QTLCanvas.this).gPanel.statusPanel.setForMainUse();
            QTLCanvas.this.mapCanvas.repaint();
            QTLCanvas.this.qtlCanvas.repaint();
        }

        private boolean detectTrack(MouseEvent e) {
            QTLCanvas.this.mouseOverTrack = e.getY() / 20;
            return QTLCanvas.this.mouseOverTrack >= 0 && QTLCanvas.this.mouseOverTrack < QTLCanvas.this.trackSet.size();
        }

        private void detectQTL(MouseEvent e) {
            if (!this.detectTrack(e)) {
                return;
            }
            QTLInfo match = null;
            ArrayList<FeatureGroup> onscreen = QTLCanvas.this.trackSet.get(QTLCanvas.this.mouseOverTrack);
            int qtlIndex = QTLCanvas.this.binarySearch(onscreen, 0, onscreen.size() - 1, QTLCanvas.this.mSPos, QTLCanvas.this.mEPos);
            if (qtlIndex != -1) {
                while (onscreen.get(qtlIndex).getMin() < QTLCanvas.this.mEPos && qtlIndex < onscreen.size() - 1) {
                    ++qtlIndex;
                }
                block1: for (int i = onscreen.subList(0, qtlIndex).size(); i >= 0; --i) {
                    FeatureGroup fg = onscreen.get(i);
                    for (int fIndex = fg.size() - 1; fIndex >= 0; --fIndex) {
                        QTLInfo qtl = fg.get(fIndex);
                        int mouseX = e.getX() - QTLCanvas.this.xOffset;
                        if (QTLCanvas.this.getPixelPosition(qtl.min()) > mouseX || QTLCanvas.this.getPixelPosition(qtl.max()) < mouseX) continue;
                        match = qtl;
                        continue block1;
                    }
                }
            }
            if (mouseOverQTL != match) {
                mouseOverQTL = match;
                if (match == null) {
                    ((QTLCanvas)QTLCanvas.this).gPanel.statusPanel.setQTLDetails(null);
                } else {
                    ((QTLCanvas)QTLCanvas.this).gPanel.statusPanel.setQTLDetails(match.getQTL());
                }
                QTLCanvas.this.mapCanvas.repaint();
                QTLCanvas.this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (mouseOverQTL == null) {
                return;
            }
            boolean undefined = true;
            boolean state = false;
            SelectedMarkersState markerStates = new SelectedMarkersState(((QTLCanvas)QTLCanvas.this).canvas.view, RB.getString((String)"gui.visualization.SelectedMarkersState.selected"));
            markerStates.createUndoState();
            double min = mouseOverQTL.min();
            double max = mouseOverQTL.max();
            QTL qtl = mouseOverQTL.getQTL();
            for (MarkerInfo mi : ((QTLCanvas)QTLCanvas.this).canvas.view.getMarkers()) {
                Marker m = mi.getMarker();
                if (!(m.getRealPosition() >= qtl.getMin()) || !(m.getRealPosition() <= qtl.getMax()) || !(m.getPosition() >= min) || !(m.getPosition() <= max)) continue;
                if (undefined) {
                    state = !mi.getSelected();
                    undefined = false;
                }
                mi.selectMarkerAndLinkedMarker(state);
            }
            if (!undefined) {
                markerStates.createRedoState();
                QTLCanvas.this.gPanel.addUndoState(markerStates);
                Flapjack.winMain.mEdit.editMode(1);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.detectQTL(e);
        }
    }

    private class Canvas2D
    extends JPanel {
        private Canvas2D() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            QTLCanvas.this.w = ((QTLCanvas)QTLCanvas.this).canvas.pX2 - ((QTLCanvas)QTLCanvas.this).canvas.pX1 + 1;
            QTLCanvas.this.xOffset = ((QTLCanvas)QTLCanvas.this).gPanel.traitCanvas.getPanelWidth() + ((QTLCanvas)QTLCanvas.this).gPanel.listPanel.getPanelWidth() + 1;
            g.setClip(QTLCanvas.this.xOffset, 0, QTLCanvas.this.w, this.getHeight());
            g.translate(QTLCanvas.this.xOffset, 0);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, QTLCanvas.this.w, this.getHeight());
            QTLCanvas.this.mSPos = ((QTLCanvas)QTLCanvas.this).mapCanvas.mSPos;
            QTLCanvas.this.mEPos = ((QTLCanvas)QTLCanvas.this).mapCanvas.mEPos;
            QTLCanvas.this.drawTracks(g);
        }
    }
}

