/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.importer;

import java.awt.Color;
import java.awt.Frame;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import jhi.brapi.api.allelematrices.BrapiAlleleMatrixDataset;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.dialog.importer.BrapiImportDialog;
import jhi.flapjack.gui.dialog.importer.IBrapiWizard;
import jhi.flapjack.io.brapi.BrapiClient;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;

class BrapiMatricesPanelNB
extends JPanel
implements IBrapiWizard {
    private BrapiClient client;
    private List<BrapiAlleleMatrixDataset> matrices;
    private BrapiImportDialog dialog;
    private DefaultComboBoxModel<String> matricesModel;
    private JLabel detailsLabel;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JComboBox<String> matricesCombo;
    private JLabel matricesLabel;
    private JTextArea text;

    public BrapiMatricesPanelNB(BrapiClient client, BrapiImportDialog dialog) {
        this.client = client;
        this.dialog = dialog;
        this.initComponents();
        this.matricesCombo.addActionListener(e -> this.displayMatrices());
    }

    private void displayMatrices() {
        int index = this.matricesCombo.getSelectedIndex();
        if (index >= 0) {
            BrapiAlleleMatrixDataset matrix = this.matrices.get(index);
            this.client.setMatrixID(matrix.getMatrixDbId());
            this.text.setText(matrix.getName() + " - " + matrix.getMatrixDbId());
        } else {
            this.text.setText("");
        }
        this.dialog.enableNext(index >= 0);
    }

    private void refreshMatrices() {
        ProgressDialog pd = new ProgressDialog((ITrackableJob)new DataDownloader(), RB.getString((String)"gui.dialog.importer.BrapiMatricesPanelNB.title"), RB.getString((String)"gui.dialog.importer.BrapiMatricesPanelNB.message"), (Frame)Flapjack.winMain);
        if (pd.failed("gui.error")) {
            return;
        }
        this.matricesModel = new DefaultComboBoxModel();
        for (BrapiAlleleMatrixDataset matrix : this.matrices) {
            this.matricesModel.addElement(matrix.getMatrixDbId() + " - " + matrix.getName());
        }
        this.matricesCombo.setModel(this.matricesModel);
        this.displayMatrices();
        this.dialog.enableNext(this.matricesModel.getSize() > 0);
    }

    @Override
    public void onShow() {
        this.dialog.enableBack(true);
        this.dialog.enableNext(this.matricesModel != null && this.matricesModel.getSize() > 0);
        if (this.matricesModel == null || this.matricesModel.getSize() == 0) {
            this.refreshMatrices();
        }
    }

    @Override
    public void onNext() {
        this.dialog.wizardCompleted();
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public String getCardName() {
        return "matrices";
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.matricesLabel = new JLabel();
        this.matricesCombo = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.text = new JTextArea();
        this.detailsLabel = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Matrix selection:"));
        this.matricesLabel.setLabelFor(this.matricesCombo);
        this.matricesLabel.setText("Available matrices:");
        this.text.setEditable(false);
        this.text.setColumns(20);
        this.text.setRows(5);
        this.jScrollPane1.setViewportView(this.text);
        this.detailsLabel.setText("Details:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.matricesLabel).addGap(11, 11, 11).addComponent(this.matricesCombo, 0, -1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.detailsLabel).addGap(0, 405, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.matricesLabel).addComponent(this.matricesCombo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.detailsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 153, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private class DataDownloader
    extends SimpleJob {
        private DataDownloader() {
        }

        public void runJob(int jobID) throws Exception {
            BrapiMatricesPanelNB.this.matrices = BrapiMatricesPanelNB.this.client.getMatrices();
        }
    }
}

