/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import java.awt.Frame;
import java.io.File;
import jhi.flapjack.analysis.CalculateSimilarityMatrix;
import jhi.flapjack.analysis.DendrogramGenerator;
import jhi.flapjack.analysis.MabcAnalysis;
import jhi.flapjack.analysis.PCoAGenerator;
import jhi.flapjack.analysis.PedVerF1sAnalysis;
import jhi.flapjack.analysis.PedVerLinesAnalysis;
import jhi.flapjack.analysis.SimulateF1;
import jhi.flapjack.analysis.SortLinesAlphabetically;
import jhi.flapjack.analysis.SortLinesBySimilarity;
import jhi.flapjack.analysis.SortLinesByTrait;
import jhi.flapjack.analysis.SortLinesExternally;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.NavPanel;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.WinMain;
import jhi.flapjack.gui.dialog.BrowseDialog;
import jhi.flapjack.gui.dialog.analysis.CalculateSimMatrixDialog;
import jhi.flapjack.gui.dialog.analysis.DendrogramSettingsDialog;
import jhi.flapjack.gui.dialog.analysis.MABCStatsDialog;
import jhi.flapjack.gui.dialog.analysis.PCoASettingsDialog;
import jhi.flapjack.gui.dialog.analysis.PedVerF1StatsDialog;
import jhi.flapjack.gui.dialog.analysis.PedVerLinesStatsDialog;
import jhi.flapjack.gui.dialog.analysis.SortLinesByTraitDialog;
import jhi.flapjack.gui.dialog.analysis.SortLinesDialog;
import jhi.flapjack.gui.simmatrix.SimMatrixPanel;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.undo.MovedLinesState;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class MenuAnalysis {
    private WinMain winMain;
    private NavPanel navPanel;
    private GenotypePanel gPanel;

    void setComponents(WinMain winMain, NavPanel navPanel) {
        this.winMain = winMain;
        this.navPanel = navPanel;
        this.gPanel = navPanel.getGenotypePanel();
    }

    void sortLines() {
        SortLinesDialog dialog = new SortLinesDialog(this.gPanel);
        if (dialog.isOK()) {
            boolean[] chromosomes = dialog.getSelectedChromosomes();
            GTViewSet viewSet = this.gPanel.getViewSet();
            Line line = dialog.getSelectedLine();
            SortLinesBySimilarity sort = new SortLinesBySimilarity(viewSet, line, chromosomes);
            this.runSort((ITrackableJob)sort, viewSet);
        }
    }

    public void sortLinesByTrait() {
        SortLinesByTraitDialog dialog = new SortLinesByTraitDialog(this.gPanel);
        if (dialog.isOK()) {
            GTViewSet viewSet = this.gPanel.getViewSet();
            int[] traits = dialog.getTraitIndices();
            boolean[] asc = dialog.getAscendingIndices();
            boolean assign = Prefs.guiAssignTraits;
            SortLinesByTrait sort = new SortLinesByTrait(viewSet, traits, asc, assign);
            this.runSort((ITrackableJob)sort, viewSet);
        }
    }

    void sortLinesByExternal() {
        String rbTitle = "gui.MenuData.sortExternal.title";
        String rbLabel = "gui.MenuData.sortExternal.label";
        String rbButton = "gui.MenuData.sortExternal.button";
        String help = "_-_Sort_Lines";
        BrowseDialog browseDialog = new BrowseDialog(Prefs.guiExternalSortHistory, rbTitle, rbLabel, rbButton, help);
        if (browseDialog.isOK()) {
            File file = browseDialog.getFile();
            Prefs.guiExternalSortHistory = browseDialog.getHistory();
            GTViewSet viewSet = this.gPanel.getViewSet();
            SortLinesExternally sort = new SortLinesExternally(viewSet, file);
            this.runSort((ITrackableJob)sort, viewSet);
        }
    }

    void sortLinesAlphabetically() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        SortLinesAlphabetically sort = new SortLinesAlphabetically(viewSet);
        this.runSort((ITrackableJob)sort, viewSet);
    }

    public void runSort(ITrackableJob sort, GTViewSet viewSet) {
        MovedLinesState state = this.setupSort(viewSet);
        ProgressDialog dialog = new ProgressDialog(sort, RB.getString((String)"gui.MenuData.sorting.title"), RB.getString((String)"gui.MenuData.sorting.label"), (Frame)Flapjack.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        this.completeSort(state);
    }

    private MovedLinesState setupSort(GTViewSet viewSet) {
        MovedLinesState state = new MovedLinesState(viewSet, RB.getString((String)"gui.visualization.MovedLinesState.sortedLines"));
        viewSet.setDisplayLineScores(false);
        Flapjack.winMain.getNavPanel().getGenotypePanel();
        state.createUndoState();
        return state;
    }

    private void completeSort(MovedLinesState state) {
        state.createRedoState();
        this.gPanel.addUndoState(state);
        this.gPanel.refreshView();
        this.gPanel.moveToPosition(0, -1, false);
        Actions.projectModified();
    }

    public void simMatrix() {
        GTViewSet viewSet = this.gPanel.getViewSet();
        GTView view = this.gPanel.getView();
        if (view.countSelectedLines() < 2) {
            TaskDialog.warning((String)RB.getString((String)"gui.MenuAnalysis.simMatrix.lineWarning"), (String)RB.getString((String)"gui.text.close"));
            return;
        }
        CalculateSimMatrixDialog matrixDialog = new CalculateSimMatrixDialog(viewSet);
        if (!matrixDialog.isOK()) {
            return;
        }
        CalculateSimilarityMatrix calculator = new CalculateSimilarityMatrix(viewSet, view, matrixDialog.getSelectedChromosomes(), true);
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)calculator, RB.getString((String)"gui.MenuAnalysis.simMatrix.title"), RB.getString((String)"gui.MenuAnalysis.simMatrix.label"), (Frame)Flapjack.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        SimMatrix matrix = calculator.getMatrix();
        int id = viewSet.getDataSet().getMatrixCount() + 1;
        viewSet.getDataSet().setMatrixCount(id);
        String title = RB.format((String)"gui.MenuAnalysis.simMatrix.name", (Object[])new Object[]{id, matrix.getLineInfos().size(), matrix.getLineInfos().size()});
        matrix.setTitle(title);
        this.navPanel.addSimMatrixNode(viewSet, matrix);
        Actions.projectModified();
    }

    public void dendrogram() {
        GTViewSet newViewSet;
        DendrogramSettingsDialog dsd = new DendrogramSettingsDialog();
        if (!dsd.isOK()) {
            return;
        }
        SimMatrixPanel panel = this.navPanel.getActiveSimMatrixPanel();
        GTViewSet viewSet = panel.getViewSet();
        SimMatrix matrix = panel.getSimMatrix();
        DendrogramGenerator dg = new DendrogramGenerator(matrix, newViewSet = viewSet.createClone("", true));
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)dg, RB.getString((String)"gui.MenuAnalysis.dendrogram.title"), RB.getString((String)"gui.MenuAnalysis.dendrogram.label"), (Frame)Flapjack.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        int id = viewSet.getDataSet().getDendrogramCount() + 1;
        viewSet.getDataSet().setDendrogramCount(id);
        String title = RB.format((String)"gui.MenuAnalysis.dendrogram.name", (Object[])new Object[]{id, matrix.getLineInfos().size()});
        dg.getDendrogram().setTitle(title);
        title = RB.format((String)"gui.MenuAnalysis.dendrogram.view", (Object[])new Object[]{id});
        newViewSet.setName(title);
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        dataSet.getViewSets().add(newViewSet);
        this.navPanel.addVisualizationNode(dataSet, newViewSet);
        Actions.projectModified();
    }

    public void principalCordAnalysis() {
        String noDimensions;
        SimMatrix matrix;
        int noLines = this.navPanel.getActiveSimMatrixPanel().getViewSet().getLines().size();
        PCoASettingsDialog psd = new PCoASettingsDialog(noLines);
        if (!psd.isOK()) {
            return;
        }
        SimMatrixPanel panel = this.navPanel.getActiveSimMatrixPanel();
        GTViewSet viewSet = panel.getViewSet();
        PCoAGenerator pco = new PCoAGenerator(viewSet, matrix = panel.getSimMatrix(), noDimensions = psd.getNoDimensions());
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)pco, RB.getString((String)"gui.MenuAnalysis.pcoa.title"), RB.getString((String)"gui.MenuAnalysis.pcoa.label"), (Frame)Flapjack.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
    }

    public void gobiiMABC() {
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        GTViewSet viewSet = this.gPanel.getViewSet();
        MABCStatsDialog dialog = new MABCStatsDialog(viewSet);
        if (!dialog.isOK()) {
            return;
        }
        boolean[] selectedChromosomes = dialog.getSelectedChromosomes();
        int rpIndex = dialog.getRecurrentParent();
        int dpIndex = dialog.getDonorParent();
        boolean simpleStats = dialog.isSimpleStats();
        MabcAnalysis stats = new MabcAnalysis(viewSet, selectedChromosomes, Prefs.mabcMaxMrkrCoverage, rpIndex, dpIndex, Prefs.guiMabcExcludeParents, simpleStats, RB.getString((String)"gui.navpanel.MabcNode.node"));
        ProgressDialog pDialog = new ProgressDialog((ITrackableJob)stats, RB.getString((String)"gui.MenuAnalysis.mabc.title"), RB.getString((String)"gui.MenuAnalysis.mabc.label"), (Frame)Flapjack.winMain);
        this.navPanel.addVisualizationNode(dataSet, stats.getViewSet());
        Actions.projectModified();
    }

    public void gobiiPedVer() {
        ProgressDialog pDialog;
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        GTViewSet viewSet = this.gPanel.getViewSet();
        GTViewSet newViewSet = viewSet.createClone("", true);
        PedVerF1StatsDialog dialog = new PedVerF1StatsDialog(viewSet);
        if (!dialog.isOK()) {
            return;
        }
        boolean[] selectedChromosomes = dialog.getSelectedChromosomes();
        int p1Index = dialog.getParent1();
        int p2Index = dialog.getParent2();
        int f1Index = dialog.getF1();
        if (dialog.simulateF1()) {
            SimulateF1 f1Sim = new SimulateF1(newViewSet, p1Index, p2Index);
            pDialog = new ProgressDialog((ITrackableJob)f1Sim, "Running F1 Simulation", "Running F1 simulation - please be patient...", (Frame)Flapjack.winMain);
            f1Index = f1Sim.getF1Index();
        }
        PedVerF1sAnalysis stats = new PedVerF1sAnalysis(newViewSet, selectedChromosomes, p1Index, p2Index, f1Index, "PedVerF1s Results");
        pDialog = new ProgressDialog((ITrackableJob)stats, "Running PedVer Stats", "Running PedVer stats - please be patient...", (Frame)Flapjack.winMain);
        newViewSet.setName("PedVerF1s View");
        dataSet.getViewSets().add(newViewSet);
        this.navPanel.addVisualizationNode(dataSet, newViewSet);
        Actions.projectModified();
    }

    public void gobiiPedVerLines() {
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        GTViewSet viewSet = this.gPanel.getViewSet();
        PedVerLinesStatsDialog dialog = new PedVerLinesStatsDialog(viewSet);
        if (!dialog.isOK()) {
            return;
        }
        boolean[] selectedChromosomes = dialog.getSelectedChromosomes();
        int refIndex = dialog.getReferenceLine();
        int testIndex = dialog.getTestLine();
        PedVerLinesAnalysis stats = new PedVerLinesAnalysis(viewSet, selectedChromosomes, refIndex, testIndex, "PedVerLines Results");
        ProgressDialog pDialog = new ProgressDialog((ITrackableJob)stats, "Running PedVer Stats", "Running PedVer stats - please be patient...", (Frame)Flapjack.winMain);
        this.navPanel.addVisualizationNode(dataSet, stats.getViewSet());
        Actions.projectModified();
    }
}

