/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.HDF5;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.PaddingUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5T;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.lang.reflect.Field;

abstract class HDF5MemberByteifyer {
    private final Field fieldOrNull;
    private final String memberName;
    protected final int maxCharacters;
    protected final int size;
    protected final int offsetOnDisk;
    protected final int offsetInMemory;
    protected final CharacterEncoding encoding;
    private final HDF5DataTypeVariant typeVariant;
    private final boolean isVariableLengthType;

    HDF5MemberByteifyer(Field fieldOrNull, String memberName, int size, int offset, int memOffset, boolean isVariableLengthType, HDF5DataTypeVariant typeVariantOrNull) {
        this(fieldOrNull, memberName, size, offset, memOffset, CharacterEncoding.ASCII, size, isVariableLengthType, false, typeVariantOrNull);
    }

    HDF5MemberByteifyer(Field fieldOrNull, String memberName, int size, int offset, int memOffset, CharacterEncoding encoding, int maxCharacters, boolean isVariableLengthType, boolean isReferenceType) {
        this(fieldOrNull, memberName, size, offset, memOffset, encoding, maxCharacters, isVariableLengthType, isReferenceType, HDF5DataTypeVariant.NONE);
    }

    private HDF5MemberByteifyer(Field fieldOrNull, String memberName, int size, int offset, int memOffset, CharacterEncoding encoding, int maxCharacters, boolean isVariableLengthType, boolean isReferenceType, HDF5DataTypeVariant typeVariantOrNull) {
        this.isVariableLengthType = isVariableLengthType;
        this.fieldOrNull = fieldOrNull;
        this.memberName = memberName;
        this.maxCharacters = maxCharacters;
        this.size = isVariableLengthType ? HDFNativeData.getMachineWordSize() : (isReferenceType ? 8 : size);
        this.offsetOnDisk = offset;
        this.offsetInMemory = PaddingUtils.padOffset(memOffset, this.getElementSize());
        this.encoding = encoding;
        this.typeVariant = HDF5DataTypeVariant.maskNull(typeVariantOrNull);
    }

    abstract int getElementSize();

    abstract byte[] byteify(int var1, Object var2) throws IllegalAccessException;

    abstract void setFromByteArray(int var1, Object var2, byte[] var3, int var4) throws IllegalAccessException;

    abstract int getMemberStorageTypeId();

    abstract int getMemberNativeTypeId();

    HDF5EnumerationType tryGetEnumType() {
        return null;
    }

    void insertType(int dataTypeId) {
        H5T.H5Tinsert(dataTypeId, this.memberName, this.offsetOnDisk, this.getMemberStorageTypeId());
    }

    void insertNativeType(int dataTypeId, HDF5 h5, ICleanUpRegistry registry) {
        if (this.getMemberNativeTypeId() < 0) {
            H5T.H5Tinsert(dataTypeId, this.memberName, this.offsetInMemory, h5.getNativeDataType(this.getMemberStorageTypeId(), registry));
        } else {
            H5T.H5Tinsert(dataTypeId, this.memberName, this.offsetInMemory, this.getMemberNativeTypeId());
        }
    }

    String getMemberName() {
        return this.memberName;
    }

    Field tryGetField() {
        return this.fieldOrNull;
    }

    int getMaxCharacters() {
        return this.maxCharacters;
    }

    int getSize() {
        return this.size;
    }

    int getOffsetOnDisk() {
        return this.offsetOnDisk;
    }

    int getTotalSizeOnDisk() {
        return this.offsetOnDisk + this.size;
    }

    int getOffsetInMemory() {
        return this.offsetInMemory;
    }

    int getTotalSizeInMemory() {
        return this.offsetInMemory + this.size;
    }

    HDF5DataTypeVariant getTypeVariant() {
        return this.typeVariant;
    }

    boolean isVariableLengthType() {
        return this.isVariableLengthType;
    }

    String describe() {
        if (this.fieldOrNull != null) {
            return "field '" + this.fieldOrNull.getName() + "' of class '" + this.fieldOrNull.getDeclaringClass().getCanonicalName() + "'";
        }
        return "member '" + this.memberName + "'";
    }

    boolean isDummy() {
        return false;
    }

    boolean mayBeCut() {
        return false;
    }

    public String toString() {
        return this.describe();
    }
}

