/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import jhi.flapjack.io.cmd.CmdOptions;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class FJTabbedToHdf5Converter {
    private static final String LINES = "Lines";
    private static final String MARKERS = "Markers";
    private static final String DATA = "DataMatrix";
    private static final String STATE_TABLE = "StateTable";
    private File genotypeFile;
    private File hdf5File;

    public static void main(String[] args) {
        System.out.println("Assuming default missing data string and heterozygous separator.");
        FJTabbedToHdf5Converter converter = new FJTabbedToHdf5Converter(args);
        converter.convertToHdf5();
        System.exit(0);
    }

    private FJTabbedToHdf5Converter(String[] args) {
        CmdOptions options = new CmdOptions().withAdvancedOptions().withGenotypeFile(true).addRequiredOption("h", "hdf5", true, "FILE", "Required output file");
        try {
            CommandLine line = new DefaultParser().parse((Options)options, args);
            if (line.hasOption("genotypes")) {
                this.genotypeFile = new File(line.getOptionValue("genotypes"));
            }
            if (line.hasOption("hdf5")) {
                this.hdf5File = new File(line.getOptionValue("hdf5"));
            }
        }
        catch (Exception e) {
            options.printHelp("FJTabbedToHdf5Converter");
            System.exit(1);
        }
    }

    public FJTabbedToHdf5Converter(File genotypeFile, File hdf5File) {
        this.genotypeFile = genotypeFile;
        this.hdf5File = hdf5File;
    }

    private void checkFileExists(File file) {
        if (!file.exists()) {
            System.err.println("Genotype file doesn't exist. Please specify a valid genotype file.");
            FJTabbedToHdf5Converter.printHelp();
        }
    }

    public void convertToHdf5() {
        this.checkFileExists(this.genotypeFile);
        long s = System.currentTimeMillis();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.genotypeFile), "UTF-8"));
             LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.genotypeFile), "UTF-8"));){
            if (this.hdf5File.exists() && this.hdf5File.isFile()) {
                this.hdf5File.delete();
            }
            IHDF5Writer writer = HDF5Factory.open((File)this.hdf5File);
            LinkedHashMap<String, Byte> stateTable = new LinkedHashMap<String, Byte>();
            stateTable.put("", (byte)0);
            int counter = 0;
            int offset = 0;
            String line = reader.readLine();
            while (line.length() == 0 || line.startsWith("#")) {
                ++offset;
                line = reader.readLine();
            }
            lineNumberReader.skip(Long.MAX_VALUE);
            int nrOfRows = lineNumberReader.getLineNumber() - 1 - offset;
            String[] tokens = line.split("\t", -1);
            String[] markers = Arrays.copyOfRange(tokens, 1, tokens.length);
            long fourGig = 0x100000000L;
            int accessionChunk = (int)Math.min((double)nrOfRows, Math.max(1.0, Math.floor((double)fourGig / ((double)markers.length * 1.0))));
            int markerChunk = (int)Math.min((long)markers.length, fourGig);
            writer.int8().createMatrix(DATA, (long)nrOfRows, (long)markers.length, accessionChunk, markerChunk);
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if (counter % 1000 == 0) {
                    System.out.println("Processed: " + counter);
                }
                String[] columns = line.split("\t", -1);
                lines.add(columns[0]);
                String[] snpCalls = Arrays.copyOfRange(columns, 1, columns.length);
                Stream.of(snpCalls).forEach(token -> stateTable.putIfAbsent((String)token, (byte)stateTable.size()));
                Byte[] bytes = (Byte[])Stream.of(snpCalls).map(token -> (Byte)stateTable.get(token)).toArray(Byte[]::new);
                byte[] outBytes = this.convertBytesToPrimitive(bytes);
                if (outBytes.length != markers.length) continue;
                byte[][] outMatrixBytes = new byte[1][outBytes.length];
                outMatrixBytes[0] = outBytes;
                writer.int8().writeMatrixBlock(DATA, outMatrixBytes, (long)counter, 0L);
                ++counter;
            }
            writer.string().writeArray(MARKERS, markers, HDF5GenericStorageFeatures.GENERIC_DEFLATE);
            writer.string().writeArray(LINES, lines.toArray(new String[lines.size()]), HDF5GenericStorageFeatures.GENERIC_DEFLATE);
            writer.string().writeArray(STATE_TABLE, stateTable.keySet().toArray(new String[stateTable.keySet().size()]), HDF5GenericStorageFeatures.GENERIC_DEFLATE);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Took: " + (float)(System.currentTimeMillis() - s) / 1000.0f);
    }

    private byte[] convertBytesToPrimitive(Byte[] bytes) {
        byte[] outBytes = new byte[bytes.length];
        int i = 0;
        for (Byte b : bytes) {
            outBytes[i++] = b;
        }
        return outBytes;
    }

    private static void printHelp() {
        System.out.println("Usage: fj2hdf5 <options>\n where valid options are:\n   -genotypes=<genotypes_file>    (required input file)\n   -hdf5=<hdf5_file>              (required output file)\n");
        System.exit(1);
    }
}

