/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5ReaderConfigurator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Marker;
import jhi.flapjack.io.IMapImporter;
import jhi.flapjack.io.MarkerIndex;

public class Hdf5ChromosomeMapImporter
implements IMapImporter {
    private static final String POSITIONS_ROOT = "Positions/";
    private static final String POSITIONS = "Positions";
    private static final String SNP_IDS = "SnpIds";
    private static final String CHROMOSOMES = "Chromosomes";
    private static final String CHROMOSOME_INDICES = "ChromosomeIndices";
    private static final String SNP_POSITIONS = "Positions/Positions";
    private static final String POSITIONS_SNP_IDS = "Positions/SnpIds";
    private static final String POSITIONS_CHROMOSOMES = "Positions/Chromosomes";
    private static final String POSITIONS_CHROMOSOME_INDICES = "Positions/ChromosomeIndices";
    private final File file;
    private final DataSet dataSet;
    private final HashMap<String, MarkerIndex> markers = new HashMap();
    private final LinkedList<String> duplicates = new LinkedList();
    private final ArrayList<Integer> markerChroms = new ArrayList();
    private boolean isOK = true;
    private long markerCount = 0L;

    public Hdf5ChromosomeMapImporter(File file, DataSet dataSet) {
        this.file = file;
        this.dataSet = dataSet;
    }

    @Override
    public void importMap() throws Exception {
        long s = System.currentTimeMillis();
        IHDF5ReaderConfigurator config = HDF5Factory.configureForReading((File)this.file);
        IHDF5Reader reader = config.reader();
        double[] positions = reader.readDoubleArray(SNP_POSITIONS);
        String[] names = reader.readStringArray(POSITIONS_SNP_IDS);
        String[] chromosomes = reader.readStringArray(POSITIONS_CHROMOSOMES);
        int[] chromosomeIndices = reader.readIntArray(POSITIONS_CHROMOSOME_INDICES);
        for (int i = 0; i < names.length && this.isOK; ++i) {
            Marker marker = new Marker(names[i], positions[i]);
            MarkerIndex index = this.markers.get(marker.getName());
            if (index != null) continue;
            ChromosomeMap.Wrapper w = this.dataSet.getMapByName(chromosomes[chromosomeIndices[i]], true);
            w.map.addMarker(marker);
            this.markers.put(marker.getName(), new MarkerIndex(w.index, 0));
            this.markerChroms.add(chromosomeIndices[i]);
            ++this.markerCount;
        }
        if (this.isOK) {
            this.dataSet.orderMarkersWithinMaps();
        }
        Collections.sort(this.dataSet.getChromosomeMaps());
        System.out.println("markers.size() = " + this.markers.size());
        for (ChromosomeMap map : this.dataSet.getChromosomeMaps()) {
            int i = 0;
            for (Marker marker : map) {
                this.markers.get((Object)marker.getName()).mkrIndex = i++;
            }
        }
        System.out.println("assigned marker indexes");
        System.out.println("Time taken to read map: " + (System.currentTimeMillis() - s) + " ms");
    }

    @Override
    public long getMarkerCount() {
        return this.markerCount;
    }

    @Override
    public HashMap<String, MarkerIndex> getMarkersHashMap() {
        return this.markers;
    }

    public ArrayList<Integer> markerChromosomes() {
        return this.markerChroms;
    }

    @Override
    public void cancelImport() {
        this.isOK = false;
    }

    @Override
    public LinkedList<String> getDuplicates() {
        return this.duplicates;
    }

    @Override
    public long getBytesRead() {
        return 0L;
    }
}

