/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.StackMapTableEntry;

public final class StackMapTable
extends Attribute {
    private static final long serialVersionUID = -2931695092763099621L;
    private int map_length;
    private StackMapTableEntry[] map;

    public StackMapTable(int name_index, int length, StackMapTableEntry[] map, ConstantPool constant_pool) {
        super((byte)19, name_index, length, constant_pool);
        this.setStackMapTable(map);
    }

    StackMapTable(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (StackMapTableEntry[])null, constant_pool);
        this.map_length = file.readUnsignedShort();
        this.map = new StackMapTableEntry[this.map_length];
        for (int i = 0; i < this.map_length; ++i) {
            this.map[i] = new StackMapTableEntry(file, constant_pool);
        }
    }

    public final void setStackMapTable(StackMapTableEntry[] map) {
        this.map = map;
        this.map_length = map == null ? 0 : map.length;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder("StackMapTable(");
        for (int i = 0; i < this.map_length; ++i) {
            buf.append(this.map[i].toString());
            if (i >= this.map_length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        StackMapTable c = (StackMapTable)this.clone();
        c.map = new StackMapTableEntry[this.map_length];
        for (int i = 0; i < this.map_length; ++i) {
            c.map[i] = this.map[i].copy();
        }
        c.constant_pool = _constant_pool;
        return c;
    }
}

