/*
 * Decompiled with CFR 0.152.
 */
package jhi.gobii;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import jhi.gobii.Line;

public class HeaderCreator {
    private static final int COL_LINE_NAME = 0;
    private int colGermplasmName = -1;
    private int colGermplasmPar1 = -1;
    private int colGermplasmPar1Type = -1;
    private int colGermplasmPar2 = -1;
    private int colGermplasmPar2Type = -1;
    private int colGermplasmPar3 = -1;
    private int colGermplasmPar3Type = -1;
    private int colGermplasmPar4 = -1;
    private int colGermplasmPar4Type = -1;
    private static final String PEDIGREE_HEADER = "# fjPedigree";
    private static final String WILDCARD = "*";
    private static final String SAMPLE_FILE_HEADER = "\tgermplasm_name";
    private static final String RP = "RP";
    private static final String DP = "DP";
    private static final String NA = "N/A";
    private File sample;
    private File output;
    private File genotype;
    private ArrayList<Line> lines = new ArrayList();
    private ArrayList<String> parentTypes = new ArrayList();
    private HashMap<String, HashSet<String>> parentsByType = new HashMap();

    public static void main(String[] args) {
        if (args.length == 3) {
            HeaderCreator creator = new HeaderCreator(new File(args[0]), new File(args[1]), new File(args[2]));
            try {
                creator.processSampleFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage: jhi.gobii.HeaderCreator input_file genotype_file output_file");
        }
    }

    public HeaderCreator(File sample, File genotype, File output) {
        this.sample = sample;
        this.genotype = genotype;
        this.output = output;
        this.initParentTypes();
    }

    private void initParentTypes() {
        this.parentTypes.add(RP);
        this.parentTypes.add(DP);
        this.parentTypes.add(NA);
        for (String parentType : this.parentTypes) {
            this.parentsByType.put(parentType, new HashSet());
        }
    }

    public void processSampleFile() throws Exception {
        if (this.sample == null || !this.sample.exists()) {
            throw new FileNotFoundException("Sample file not found");
        }
        if (this.genotype == null || !this.genotype.exists()) {
            throw new FileNotFoundException("Gentoype file not found");
        }
        this.parseSampleFile();
        this.writeOutputFile();
    }

    private void parseSampleFile() throws Exception {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.sample));){
            String fileLine;
            while ((fileLine = reader.readLine()) != null) {
                if (fileLine.startsWith("# fj")) continue;
                if (fileLine.startsWith(SAMPLE_FILE_HEADER)) {
                    this.parseGobiiHeader(fileLine);
                    this.validateGobiiHeader();
                    continue;
                }
                String[] tokens = fileLine.split("\t", -1);
                String lineName = tokens[0];
                String germplasmName = tokens[this.colGermplasmName];
                boolean isParent = !tokens[39].isEmpty();
                Line line = new Line(lineName, germplasmName, isParent);
                this.lines.add(line);
                this.readParentInfo(line, tokens[this.colGermplasmPar1], tokens[this.colGermplasmPar1Type]);
                this.readParentInfo(line, tokens[this.colGermplasmPar2], tokens[this.colGermplasmPar2Type]);
                this.readParentInfo(line, tokens[this.colGermplasmPar3], tokens[this.colGermplasmPar3Type]);
                this.readParentInfo(line, tokens[this.colGermplasmPar4], tokens[this.colGermplasmPar4Type]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseGobiiHeader(String fileLine) {
        String[] tokens = fileLine.split("\t", -1);
        for (int i = 0; i < tokens.length; ++i) {
            switch (tokens[i]) {
                case "germplasm_name": {
                    this.colGermplasmName = i;
                }
                case "germplasm_par1": {
                    this.colGermplasmPar1 = i;
                }
                case "germplasm_par1_type": {
                    this.colGermplasmPar1Type = i;
                }
                case "germplasm_par2": {
                    this.colGermplasmPar2 = i;
                }
                case "germplasm_par2_type": {
                    this.colGermplasmPar2Type = i;
                }
                case "germplasm_par3": {
                    this.colGermplasmPar3 = i;
                }
                case "germplasm_par3_type": {
                    this.colGermplasmPar3Type = i;
                }
                case "germplasm_par4": {
                    this.colGermplasmPar4 = i;
                }
                case "germplasm_par4_type": {
                    this.colGermplasmPar4Type = i;
                }
            }
        }
    }

    private void validateGobiiHeader() throws Exception {
        if (this.colGermplasmName == -1) {
            throw new Exception("germplasm_name column was not found.");
        }
        if (this.colGermplasmPar1 == -1) {
            throw new Exception("germplasm_par1 column was not found.");
        }
        if (this.colGermplasmPar1Type == -1) {
            throw new Exception("germplasm_par1_type column was not found.");
        }
        if (this.colGermplasmPar2 == -1) {
            throw new Exception("germplasm_par2 column was not found.");
        }
        if (this.colGermplasmPar2Type == -1) {
            throw new Exception("germplasm_par2_type column was not found.");
        }
        if (this.colGermplasmPar3 == -1) {
            throw new Exception("germplasm_par3 column was not found.");
        }
        if (this.colGermplasmPar3Type == -1) {
            throw new Exception("germplasm_par3_type column was not found.");
        }
        if (this.colGermplasmPar4 == -1) {
            throw new Exception("germplasm_par4 column was not found.");
        }
        if (this.colGermplasmPar4Type == -1) {
            throw new Exception("germplasm_par4_type column was not found.");
        }
    }

    private void readParentInfo(Line line, String parentName, String parentType) {
        if (!parentName.isEmpty()) {
            if (parentType.isEmpty()) {
                parentType = NA;
            }
            line.addParent(parentName, parentType);
            HashSet<String> parents = this.parentsByType.get(parentType);
            parents.add(parentName);
            this.parentsByType.put(parentType, parents);
        }
    }

    private void writeOutputFile() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.genotype));
             PrintWriter writer = new PrintWriter(new FileWriter(this.output));){
            String genotypeLine = reader.readLine();
            while (genotypeLine.length() == 0 || genotypeLine.startsWith("#")) {
                writer.println(genotypeLine);
                genotypeLine = reader.readLine();
            }
            this.outputPedigreeHeader(writer);
            while (genotypeLine != null) {
                writer.println(genotypeLine);
                genotypeLine = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void outputPedigreeHeader(PrintWriter writer) {
        if (this.lines.isEmpty()) {
            return;
        }
        for (String parentType : this.parentTypes) {
            if (!this.isWildcardCase(parentType)) continue;
            writer.println(this.buildWildcardHeader(parentType));
        }
        for (Line line : this.lines) {
            if (line.getParentsByType().isEmpty()) continue;
            for (String parentType : line.getParentsByType().keySet()) {
                if (this.isWildcardCase(parentType)) continue;
                StringJoiner joiner = new StringJoiner("\t", "# fjPedigree\t", "");
                joiner.add(line.getName()).add(parentType).add(this.linesForParentType(line, parentType));
                writer.println(joiner.toString());
            }
        }
    }

    private String linesForParentType(Line line, String parentType) {
        List<String> germplasmNamesForType = line.getParentsByType().get(parentType);
        ArrayList<String> lineNames = new ArrayList<String>();
        for (String germplasm : germplasmNamesForType) {
            List<String> linesForGermplam = this.getLinesForGermplasm(germplasm);
            if (linesForGermplam == null) continue;
            lineNames.addAll(linesForGermplam);
        }
        return lineNames.stream().collect(Collectors.joining("\t"));
    }

    private List<String> getLinesForGermplasm(String germplasmName) {
        return this.lines.stream().filter(l -> l.getGermplamName().equals(germplasmName)).map(Line::getName).collect(Collectors.toCollection(ArrayList::new));
    }

    private boolean isWildcardCase(String key) {
        return this.lines.stream().filter(l -> !l.isParent()).allMatch(l -> l.hasParentType(key));
    }

    private String buildWildcardHeader(String parentType) {
        HashSet<String> rpParents = this.parentsByType.get(parentType);
        List<String> parents = this.getLinesForGermplasm(rpParents.iterator().next());
        if (rpParents.size() == 1) {
            StringJoiner joiner = new StringJoiner("\t", "# fjPedigree\t", "");
            joiner.add(WILDCARD).add(parentType).add(parents.stream().collect(Collectors.joining("\t")));
            return joiner.toString();
        }
        return "";
    }
}

