/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.util.ArrayList;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.XMLRoot;

public class GenotypeData
extends XMLRoot {
    private ChromosomeMap map;
    private byte[] loci;
    private int[] lociInt;

    public GenotypeData() {
    }

    public GenotypeData(ChromosomeMap map, boolean useByteStorage) {
        this.map = map;
        int size = map.countLoci();
        if (useByteStorage) {
            this.loci = new byte[size];
        } else {
            this.lociInt = new int[size];
        }
    }

    void validate() throws NullPointerException {
        if (this.map == null || this.loci == null && this.lociInt == null) {
            throw new NullPointerException();
        }
    }

    public ChromosomeMap getChromosomeMap() {
        return this.map;
    }

    public void setChromosomeMap(ChromosomeMap map) {
        this.map = map;
    }

    public byte[] getLoci() {
        return this.loci;
    }

    public void setLoci(byte[] loci) {
        this.loci = loci;
    }

    public int[] getLociInt() {
        return this.lociInt;
    }

    public void setLociInt(int[] lociInt) {
        this.lociInt = lociInt;
    }

    void setLoci(int index, int stateCode) {
        if (this.loci != null) {
            this.loci[index] = (byte)stateCode;
        } else {
            this.lociInt[index] = stateCode;
        }
    }

    boolean useByteStorage() {
        return this.loci != null;
    }

    public int getState(int index) throws ArrayIndexOutOfBoundsException {
        if (this.loci != null) {
            return this.loci[index];
        }
        return this.lociInt[index];
    }

    boolean isGenotypeDataForMap(ChromosomeMap map) {
        return this.map == map;
    }

    public int countLoci() {
        if (this.loci != null) {
            return this.loci.length;
        }
        return this.lociInt.length;
    }

    void collapseStates(ArrayList<Integer> remap) {
        if (this.loci != null) {
            for (int i = 0; i < this.loci.length; ++i) {
                this.loci[i] = (byte)remap.get(this.loci[i]).intValue();
            }
        } else {
            for (int i = 0; i < this.lociInt.length; ++i) {
                this.lociInt[i] = remap.get(this.lociInt[i]);
            }
        }
    }

    boolean usingByteStorage() {
        return this.loci != null;
    }
}

